/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Base64;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SaslAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SaslAuthenticationHandler.class);
    private static final AttributeKey<Authenticator.SaslNegotiator> negotiatorKey = AttributeKey.valueOf((String)"negotiator");
    private static final AttributeKey<RequestMessage> requestKey = AttributeKey.valueOf((String)"request");
    private final Authenticator authenticator;

    public SaslAuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block13: {
            if (msg instanceof RequestMessage) {
                RequestMessage requestMessage = (RequestMessage)msg;
                Attribute negotiator = ctx.attr(negotiatorKey);
                Attribute request = ctx.attr(requestKey);
                if (negotiator.get() == null) {
                    negotiator.set((Object)this.authenticator.newSaslNegotiator());
                    request.set((Object)requestMessage);
                    ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.AUTHENTICATE).create();
                    ctx.writeAndFlush((Object)authenticate);
                } else if (requestMessage.getOp().equals("authentication") && requestMessage.getArgs().containsKey("sasl")) {
                    byte[] saslResponse;
                    Object saslObject = requestMessage.getArgs().get("sasl");
                    if (saslObject instanceof byte[]) {
                        saslResponse = (byte[])saslObject;
                    } else if (saslObject instanceof String) {
                        saslResponse = Base64.getDecoder().decode((String)saslObject);
                    } else {
                        ResponseMessage error = ResponseMessage.build((RequestMessage)((RequestMessage)request.get())).statusMessage("Incorrect type for : sasl. byte[] or String is expected").code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).create();
                        ctx.writeAndFlush((Object)error);
                        return;
                    }
                    try {
                        byte[] saslMessage = ((Authenticator.SaslNegotiator)negotiator.get()).evaluateResponse(saslResponse);
                        if (((Authenticator.SaslNegotiator)negotiator.get()).isComplete()) {
                            AuthenticatedUser user = ((Authenticator.SaslNegotiator)negotiator.get()).getAuthenticatedUser();
                            ctx.pipeline().remove((ChannelHandler)this);
                            RequestMessage original = (RequestMessage)request.get();
                            ctx.fireChannelRead((Object)original);
                            break block13;
                        }
                        ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.AUTHENTICATE).result((Object)saslMessage).create();
                        ctx.writeAndFlush((Object)authenticate);
                    }
                    catch (AuthenticationException ae) {
                        ResponseMessage error = ResponseMessage.build((RequestMessage)((RequestMessage)request.get())).statusMessage(ae.getMessage()).code(ResponseStatusCode.UNAUTHORIZED).create();
                        ctx.writeAndFlush((Object)error);
                    }
                } else {
                    ResponseMessage error = ResponseMessage.build((RequestMessage)requestMessage).statusMessage("Failed to authenticate").code(ResponseStatusCode.UNAUTHORIZED).create();
                    ctx.writeAndFlush((Object)error);
                }
            } else {
                logger.warn("{} only processes RequestMessage instances - received {} - channel closing", (Object)((Object)((Object)this)).getClass().getSimpleName(), msg.getClass());
                ctx.close();
            }
        }
    }
}

