/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SaslAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SaslAuthenticationHandler.class);
    private static final AttributeKey<Authenticator.SaslNegotiator> negotiatorKey = AttributeKey.valueOf((String)"negotiator");
    private static final AttributeKey<RequestMessage> requestKey = AttributeKey.valueOf((String)"request");
    private final Authenticator authenticator;

    public SaslAuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block9: {
            if (msg instanceof RequestMessage) {
                RequestMessage requestMessage = (RequestMessage)msg;
                Attribute negotiator = ctx.attr(negotiatorKey);
                Attribute request = ctx.attr(requestKey);
                if (negotiator.get() == null) {
                    negotiator.set((Object)this.authenticator.newSaslNegotiator());
                    request.set((Object)requestMessage);
                    ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.AUTHENTICATE).create();
                    ctx.writeAndFlush((Object)authenticate);
                } else if (requestMessage.getOp().equals("authentication") && requestMessage.getArgs().containsKey("sasl")) {
                    byte[] saslResponse = (byte[])requestMessage.getArgs().get("sasl");
                    try {
                        byte[] saslMessage = ((Authenticator.SaslNegotiator)negotiator.get()).evaluateResponse(saslResponse);
                        if (((Authenticator.SaslNegotiator)negotiator.get()).isComplete()) {
                            AuthenticatedUser user = ((Authenticator.SaslNegotiator)negotiator.get()).getAuthenticatedUser();
                            ctx.pipeline().remove((ChannelHandler)this);
                            RequestMessage original = (RequestMessage)request.get();
                            ctx.fireChannelRead((Object)original);
                            break block9;
                        }
                        ResponseMessage authenticate = ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.AUTHENTICATE).result((Object)saslMessage).create();
                        ctx.writeAndFlush((Object)authenticate);
                    }
                    catch (AuthenticationException ae) {
                        ResponseMessage error = ResponseMessage.build((RequestMessage)((RequestMessage)request.get())).statusMessage(ae.getMessage()).code(ResponseStatusCode.UNAUTHORIZED).create();
                        ctx.writeAndFlush((Object)error);
                    }
                } else {
                    ResponseMessage error = ResponseMessage.build((RequestMessage)requestMessage).statusMessage("Failed to authenticate").code(ResponseStatusCode.UNAUTHORIZED).create();
                    ctx.writeAndFlush((Object)error);
                }
            } else {
                logger.warn("{} only processes RequestMessage instances - received {} - channel closing", (Object)((Object)((Object)this)).getClass().getSimpleName(), msg.getClass());
                ctx.close();
            }
        }
    }
}

