/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;

public class HttpBasicAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    private final Authenticator authenticator;
    private final Base64.Decoder decoder = Base64.getUrlDecoder();

    public HttpBasicAuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage request = (FullHttpMessage)msg;
            if (!request.headers().contains("Authorization")) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED));
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            String authorizationHeader = request.headers().get("Authorization");
            String authorization = new String(this.decoder.decode(authorizationHeader), Charset.forName("UTF-8"));
            String[] split = authorization.split(":");
            if (split.length != 2) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED));
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", split[0]);
            credentials.put("password", split[1]);
            try {
                this.authenticator.authenticate(credentials);
                ctx.fireChannelRead((Object)request);
            }
            catch (AuthenticationException ae) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED));
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }
}

