/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.NioGremlinBinaryRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.NioGremlinResponseEncoder;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(NioChannelizer.class);
    private NioGremlinBinaryRequestDecoder nioGremlinBinaryRequestDecoder;
    private SaslAuthenticationHandler authenticationHandler;

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.nioGremlinBinaryRequestDecoder = new NioGremlinBinaryRequestDecoder(this.serializers);
        if (this.authenticator != null) {
            this.authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : new SaslAuthenticationHandler(this.authenticator);
        }
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("response-encoder", (ChannelHandler)new NioGremlinResponseEncoder());
        pipeline.addLast("request-binary-decoder", (ChannelHandler)this.nioGremlinBinaryRequestDecoder);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-codec", LogLevel.DEBUG)});
        }
        if (this.authenticationHandler != null) {
            pipeline.addLast("authenticator", (ChannelHandler)this.authenticationHandler);
        }
    }
}

