/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.standard;

import java.util.Map;
import java.util.Optional;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "";

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    private void evalOp(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        logger.debug("Sessionless request {} for eval in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        super.evalOpInternal(context, context::getGremlinExecutor, () -> {
            SimpleBindings bindings = new SimpleBindings();
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        });
    }
}

