/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.List;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;

@ChannelHandler.Sharable
public class WsGremlinTextRequestDecoder
extends MessageToMessageDecoder<TextWebSocketFrame> {
    protected void decode(ChannelHandlerContext channelHandlerContext, TextWebSocketFrame frame, List<Object> objects) throws Exception {
        MessageTextSerializer serializer = (MessageTextSerializer)Serializers.DEFAULT_REQUEST_SERIALIZER;
        channelHandlerContext.channel().attr(StateKey.SERIALIZER).set((Object)serializer);
        channelHandlerContext.channel().attr(StateKey.USE_BINARY).set((Object)false);
        try {
            objects.add(serializer.deserializeRequest(frame.text()));
        }
        catch (SerializationException se) {
            objects.add(RequestMessage.INVALID);
        }
    }
}

