/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.Graphs;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.IteratorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpExecutorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpSelectorHandler;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelizer
extends ChannelInitializer<SocketChannel>
implements Channelizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelizer.class);
    protected Settings settings;
    protected GremlinExecutor gremlinExecutor;
    protected Optional<SSLEngine> sslEngine;
    protected Graphs graphs;
    protected ExecutorService gremlinExecutorService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected static final String PIPELINE_SSL = "ssl";
    protected static final String PIPELINE_OP_SELECTOR = "op-selector";
    protected static final String PIPELINE_RESULT_ITERATOR_HANDLER = "result-iterator-handler";
    protected static final String PIPELINE_OP_EXECUTOR = "op-executor";
    protected final Map<String, MessageSerializer> serializers = new HashMap<String, MessageSerializer>();
    private OpSelectorHandler opSelectorHandler;
    private OpExecutorHandler opExecutorHandler;
    private IteratorHandler iteratorHandler;

    public abstract void configure(ChannelPipeline var1);

    public void finalize(ChannelPipeline pipeline) {
    }

    @Override
    public void init(Settings settings, GremlinExecutor gremlinExecutor, ExecutorService gremlinExecutorService, Graphs graphs, ScheduledExecutorService scheduledExecutorService) {
        this.settings = settings;
        this.gremlinExecutor = gremlinExecutor;
        this.graphs = graphs;
        this.gremlinExecutorService = gremlinExecutorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.configureSerializers();
        this.sslEngine = settings.optionalSsl().isPresent() && settings.ssl.enabled ? Optional.ofNullable(this.createSslEngine()) : Optional.empty();
        this.opSelectorHandler = new OpSelectorHandler(settings, graphs, gremlinExecutor, scheduledExecutorService);
        this.opExecutorHandler = new OpExecutorHandler(settings, graphs, gremlinExecutor, scheduledExecutorService);
        this.iteratorHandler = new IteratorHandler(settings);
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.sslEngine.ifPresent(ssl -> pipeline.addLast(PIPELINE_SSL, (ChannelHandler)new SslHandler(ssl)));
        this.configure(pipeline);
        pipeline.addLast(PIPELINE_OP_SELECTOR, (ChannelHandler)this.opSelectorHandler);
        pipeline.addLast(PIPELINE_RESULT_ITERATOR_HANDLER, (ChannelHandler)this.iteratorHandler);
        pipeline.addLast(PIPELINE_OP_EXECUTOR, (ChannelHandler)this.opExecutorHandler);
        this.finalize(pipeline);
    }

    private void configureSerializers() {
        this.settings.serializers.stream().map(config -> {
            try {
                Class<?> clazz = Class.forName(config.className);
                if (!MessageSerializer.class.isAssignableFrom(clazz)) {
                    logger.warn("The {} serialization class does not implement {} - it will not be available.", (Object)config.className, (Object)MessageSerializer.class.getCanonicalName());
                    return Optional.empty();
                }
                MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
                if (config.config != null) {
                    serializer.configure(config.config, this.graphs.getGraphs());
                }
                return Optional.ofNullable(serializer);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Could not find configured serializer class - {} - it will not be available", (Object)config.className);
                return Optional.empty();
            }
            catch (Exception ex) {
                logger.warn("Could not instantiate configured serializer class - {} - it will not be available. {}", (Object)config.className, (Object)ex.getMessage());
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).flatMap(serializer -> Stream.of(serializer.mimeTypesSupported()).map(mimeType -> Pair.with((Object)mimeType, (Object)serializer))).forEach(pair -> {
            String mimeType = ((String)pair.getValue0()).toString();
            MessageSerializer serializer = (MessageSerializer)pair.getValue1();
            if (this.serializers.containsKey(mimeType)) {
                logger.warn("{} already has {} configured.  It will not be replaced by {}. Check configuration for serializer duplication or other issues.", new Object[]{mimeType, this.serializers.get(mimeType).getClass().getName(), serializer.getClass().getName()});
            } else {
                logger.info("Configured {} with {}", (Object)mimeType, (Object)((MessageSerializer)pair.getValue1()).getClass().getName());
                this.serializers.put(mimeType, serializer);
            }
        });
        if (this.serializers.size() == 0) {
            logger.error("No serializers were successfully configured - server will not start.");
            throw new RuntimeException("Serialization configuration error.");
        }
    }

    private SSLEngine createSslEngine() {
        try {
            logger.info("SSL was enabled.  Initializing SSLEngine instance...");
            SSLEngine engine = this.createSSLContext(this.settings).createSSLEngine();
            engine.setUseClientMode(false);
            logger.info("SSLEngine was properly configured and initialized.");
            return engine;
        }
        catch (Exception ex) {
            logger.warn("SSL could not be enabled.  Check the ssl section of the configuration file.", (Throwable)ex);
            return null;
        }
    }

    private SSLContext createSSLContext(Settings settings) throws Exception {
        Object tmf;
        Settings.SslSettings sslSettings = settings.ssl;
        TrustManager[] managers = null;
        if (sslSettings.trustStoreFile != null) {
            KeyStore ts = KeyStore.getInstance(Optional.ofNullable(sslSettings.trustStoreFormat).orElseThrow(() -> new IllegalStateException("The trustStoreFormat is not set")));
            try (FileInputStream trustStoreInputStream = new FileInputStream(Optional.ofNullable(sslSettings.trustStoreFile).orElseThrow(() -> new IllegalStateException("The trustStoreFile is not set")));){
                ts.load(trustStoreInputStream, sslSettings.trustStorePassword.toCharArray());
            }
            String trustStoreAlgorithm = Optional.ofNullable(sslSettings.trustStoreAlgorithm).orElse(TrustManagerFactory.getDefaultAlgorithm());
            tmf = TrustManagerFactory.getInstance(trustStoreAlgorithm);
            ((TrustManagerFactory)tmf).init(ts);
            managers = ((TrustManagerFactory)tmf).getTrustManagers();
        }
        KeyStore ks = KeyStore.getInstance(Optional.ofNullable(sslSettings.keyStoreFormat).orElseThrow(() -> new IllegalStateException("The keyStoreFormat is not set")));
        FileInputStream keyStoreInputStream = new FileInputStream(Optional.ofNullable(sslSettings.keyStoreFile).orElseThrow(() -> new IllegalStateException("The keyStoreFile is not set")));
        tmf = null;
        try {
            ks.load(keyStoreInputStream, sslSettings.keyStorePassword.toCharArray());
        }
        catch (Throwable throwable) {
            tmf = throwable;
            throw throwable;
        }
        finally {
            if (keyStoreInputStream != null) {
                if (tmf != null) {
                    try {
                        ((InputStream)keyStoreInputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)tmf).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)keyStoreInputStream).close();
                }
            }
        }
        String keyManagerAlgorithm = Optional.ofNullable(sslSettings.keyManagerAlgorithm).orElse(KeyManagerFactory.getDefaultAlgorithm());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        kmf.init(ks, Optional.ofNullable(sslSettings.keyManagerPassword).orElseThrow(() -> new IllegalStateException("The keyManagerPassword is not set")).toCharArray());
        SSLContext serverContext = SSLContext.getInstance("TLS");
        serverContext.init(kmf.getKeyManagers(), managers, null);
        return serverContext;
    }
}

