/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.control;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.driver.Tokens;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.OpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.op.control.ControlOps;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlOpProcessor
implements OpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ControlOpProcessor.class);
    private static final Meter controlOpMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"op", "control"}));
    public static final String OP_PROCESSOR_NAME = "control";

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public ThrowingConsumer<Context> select(Context ctx) throws OpProcessorException {
        ThrowingConsumer<Context> op;
        RequestMessage message = ctx.getRequestMessage();
        logger.debug("Selecting processor for RequestMessage {}", (Object)message);
        switch (message.getOp()) {
            case "version": {
                op = ControlOps::versionOp;
                break;
            }
            case "import": {
                op = ControlOpProcessor.validateImportMessage(message).orElse((ThrowingConsumer<Context>)((ThrowingConsumer)ControlOps::importOp));
                break;
            }
            case "reset": {
                op = ControlOps::resetOp;
                break;
            }
            case "show": {
                op = ControlOpProcessor.validateShowMessage(message).orElse((ThrowingConsumer<Context>)((ThrowingConsumer)ControlOps::showOp));
                break;
            }
            case "use": {
                op = ControlOpProcessor.validateUseMessage(message).orElse((ThrowingConsumer<Context>)((ThrowingConsumer)ControlOps::useOp));
                break;
            }
            case "invalid": {
                String msgInvalid = String.format("Message could not be parsed.  Check the format of the request. [%s]", message);
                throw new OpProcessorException(msgInvalid, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).result((Object)msgInvalid).create());
            }
            default: {
                String msgDefault = String.format("Message with op code [%s] is not recognized.", message.getOp());
                throw new OpProcessorException(msgDefault, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_MALFORMED_REQUEST).result((Object)msgDefault).create());
            }
        }
        controlOpMeter.mark();
        return op;
    }

    private static Optional<ThrowingConsumer<Context>> validateImportMessage(RequestMessage message) throws OpProcessorException {
        Optional l = message.optionalArgs("imports");
        if (!l.isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "import", "imports");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        if (((List)l.orElse(new ArrayList())).size() == 0) {
            String msg = String.format("A message with an [%s] op code requires that the [%s] argument has at least one import string specified.", "import", "imports");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        return Optional.empty();
    }

    private static Optional<ThrowingConsumer<Context>> validateShowMessage(RequestMessage message) throws OpProcessorException {
        Optional infoType = message.optionalArgs("infoType");
        if (!infoType.isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "show", "infoType");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        if (!Tokens.INFO_TYPES.contains(infoType.get())) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument with one of the following values [%s].", "show", "infoType", Tokens.INFO_TYPES);
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        return Optional.empty();
    }

    private static Optional<ThrowingConsumer<Context>> validateUseMessage(RequestMessage message) throws OpProcessorException {
        Optional l = message.optionalArgs("coordinates");
        if (!l.isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument.", "use", "coordinates");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        List coordinates = l.orElse(new ArrayList());
        if (coordinates.size() == 0) {
            String msg = String.format("A message with an [%s] op code requires that the [%s] argument has at least one set of valid maven coordinates specified.", "use", "coordinates");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        if (!coordinates.stream().allMatch(ControlOpProcessor::validateCoordinates)) {
            String msg = String.format("A message with an [%s] op code requires that all [%s] specified are valid maven coordinates with a group, artifact, and version.", "use", "coordinates");
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).result((Object)msg).create());
        }
        return Optional.empty();
    }

    private static boolean validateCoordinates(Object coordinates) {
        if (!(coordinates instanceof Map)) {
            return false;
        }
        Map m = (Map)coordinates;
        return m.containsKey("group") && m.containsKey("artifact") && m.containsKey("version");
    }
}

