package org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential;

import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CredentialTraversalSource extends CredentialTraversalSourceDsl {
  public CredentialTraversalSource(Graph graph) {
    super(graph);
  }

  public CredentialTraversalSource(Graph graph, TraversalStrategies strategies) {
    super(graph, strategies);
  }

  @Override
  public CredentialTraversalSource clone() {
    return (CredentialTraversalSource) super.clone();
  }

  @Override
  public CredentialTraversalSource with(String key) {
    return (CredentialTraversalSource) super.with(key);
  }

  @Override
  public CredentialTraversalSource with(String key, Object value) {
    return (CredentialTraversalSource) super.with(key,value);
  }

  @Override
  public CredentialTraversalSource withStrategies(TraversalStrategy... traversalStrategies) {
    return (CredentialTraversalSource) super.withStrategies(traversalStrategies);
  }

  @Override
  public CredentialTraversalSource withoutStrategies(Class<? extends TraversalStrategy>... traversalStrategyClasses) {
    return (CredentialTraversalSource) super.withoutStrategies(traversalStrategyClasses);
  }

  @Override
  public CredentialTraversalSource withComputer(Computer computer) {
    return (CredentialTraversalSource) super.withComputer(computer);
  }

  @Override
  public CredentialTraversalSource withComputer(Class<? extends GraphComputer> graphComputerClass) {
    return (CredentialTraversalSource) super.withComputer(graphComputerClass);
  }

  @Override
  public CredentialTraversalSource withComputer() {
    return (CredentialTraversalSource) super.withComputer();
  }

  @Override
  public <A> CredentialTraversalSource withSideEffect(String key, Supplier<A> initialValue,
      BinaryOperator<A> reducer) {
    return (CredentialTraversalSource) super.withSideEffect(key,initialValue,reducer);
  }

  @Override
  public <A> CredentialTraversalSource withSideEffect(String key, A initialValue,
      BinaryOperator<A> reducer) {
    return (CredentialTraversalSource) super.withSideEffect(key,initialValue,reducer);
  }

  @Override
  public <A> CredentialTraversalSource withSideEffect(String key, A initialValue) {
    return (CredentialTraversalSource) super.withSideEffect(key,initialValue);
  }

  @Override
  public <A> CredentialTraversalSource withSideEffect(String key, Supplier<A> initialValue) {
    return (CredentialTraversalSource) super.withSideEffect(key,initialValue);
  }

  @Override
  public <A> CredentialTraversalSource withSack(Supplier<A> initialValue,
      UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,splitOperator,mergeOperator);
  }

  @Override
  public <A> CredentialTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator,
      BinaryOperator<A> mergeOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,splitOperator,mergeOperator);
  }

  @Override
  public <A> CredentialTraversalSource withSack(A initialValue) {
    return (CredentialTraversalSource) super.withSack(initialValue);
  }

  @Override
  public <A> CredentialTraversalSource withSack(Supplier<A> initialValue) {
    return (CredentialTraversalSource) super.withSack(initialValue);
  }

  @Override
  public <A> CredentialTraversalSource withSack(Supplier<A> initialValue,
      UnaryOperator<A> splitOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,splitOperator);
  }

  @Override
  public <A> CredentialTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,splitOperator);
  }

  @Override
  public <A> CredentialTraversalSource withSack(Supplier<A> initialValue,
      BinaryOperator<A> mergeOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,mergeOperator);
  }

  @Override
  public <A> CredentialTraversalSource withSack(A initialValue, BinaryOperator<A> mergeOperator) {
    return (CredentialTraversalSource) super.withSack(initialValue,mergeOperator);
  }

  @Override
  public CredentialTraversalSource withBulk(boolean useBulk) {
    return (CredentialTraversalSource) super.withBulk(useBulk);
  }

  @Override
  public CredentialTraversalSource withPath() {
    return (CredentialTraversalSource) super.withPath();
  }

  @Override
  public CredentialTraversalSource withRemote(Configuration conf) {
    return (CredentialTraversalSource) super.withRemote(conf);
  }

  @Override
  public CredentialTraversalSource withRemote(String configFile) throws Exception {
    return (CredentialTraversalSource) super.withRemote(configFile);
  }

  @Override
  public CredentialTraversalSource withRemote(RemoteConnection connection) {
    return (CredentialTraversalSource) super.withRemote(connection);
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> users() {
    CredentialTraversalSource clone = this.clone();
    return new DefaultCredentialTraversal (clone, super.users().asAdmin());
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> users(final String username, final String... more) {
    CredentialTraversalSource clone = this.clone();
    return new DefaultCredentialTraversal (clone, super.users(username,more).asAdmin());
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> user(final String username, final String password) {
    CredentialTraversalSource clone = this.clone();
    return new DefaultCredentialTraversal (clone, super.user(username,password).asAdmin());
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> addV() {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.addV);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new AddVertexStartStep(traversal, (String) null));
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> addV(String label) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.addV, label);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new AddVertexStartStep(traversal, label));
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> addV(Traversal vertexLabelTraversal) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.addV, vertexLabelTraversal);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new AddVertexStartStep(traversal, vertexLabelTraversal));
  }

  @Override
  public CredentialTraversal<Edge, Edge> addE(String label) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.addV, label);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new AddEdgeStartStep(traversal, label));
  }

  @Override
  public CredentialTraversal<Edge, Edge> addE(Traversal edgeLabelTraversal) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.addV, edgeLabelTraversal);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new AddEdgeStartStep(traversal, edgeLabelTraversal));
  }

  @Override
  public CredentialTraversal<Vertex, Vertex> V(Object... vertexIds) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.V, vertexIds);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new GraphStep(traversal, Vertex.class, true, vertexIds));
  }

  @Override
  public CredentialTraversal<Edge, Edge> E(Object... edgeIds) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.E, edgeIds);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new GraphStep(traversal, Edge.class, true, edgeIds));
  }

  @Override
  public <S> CredentialTraversal<S, S> inject(S... starts) {
    CredentialTraversalSource clone = this.clone();
    clone.getBytecode().addStep(GraphTraversal.Symbols.inject, starts);
    DefaultCredentialTraversal traversal = new DefaultCredentialTraversal(clone);
    return (CredentialTraversal) traversal.asAdmin().addStep(new InjectStep(traversal, starts));
  }

  @Override
  public Optional<Class> getAnonymousTraversalClass() {
    return Optional.of(__.class);
  }
}
