/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public final class GroovyTranslator
implements Translator.ScriptTranslator {
    private static final boolean IS_TESTING = Boolean.valueOf(System.getProperty("is.testing", "false"));
    private final String traversalSource;

    private GroovyTranslator(String traversalSource) {
        this.traversalSource = traversalSource;
    }

    public static final GroovyTranslator of(String traversalSource) {
        return new GroovyTranslator(traversalSource);
    }

    public String translate(Bytecode bytecode) {
        return this.internalTranslate(this.traversalSource, bytecode);
    }

    public String getTargetLanguage() {
        return "gremlin-groovy";
    }

    public String toString() {
        return StringFactory.translatorString((Translator)this);
    }

    public String getTraversalSource() {
        return this.traversalSource;
    }

    private String internalTranslate(String start, Bytecode bytecode) {
        StringBuilder traversalScript = new StringBuilder(start);
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            String methodName = instruction.getOperator();
            if (IS_TESTING && instruction.getOperator().equals("withStrategies") && instruction.getArguments()[0].toString().contains("TranslationStrategy")) continue;
            if (0 == instruction.getArguments().length) {
                traversalScript.append(".").append(methodName).append("()");
                continue;
            }
            traversalScript.append(".");
            String temp = methodName + "(";
            for (Object object : instruction.getArguments()) {
                temp = temp + this.convertToString(object) + ",";
            }
            traversalScript.append(temp.substring(0, temp.length() - 1)).append(")");
        }
        return traversalScript.toString();
    }

    private String convertToString(Object object) {
        if (object instanceof Bytecode.Binding) {
            return ((Bytecode.Binding)object).variable();
        }
        if (object instanceof Bytecode) {
            return this.internalTranslate("__", (Bytecode)object);
        }
        if (object instanceof Traversal) {
            return this.convertToString(((Traversal)object).asAdmin().getBytecode());
        }
        if (object instanceof String) {
            return (((String)object).contains("\"") ? "\"\"\"" + object + "\"\"\"" : "\"" + object + "\"").replace("$", "\\$");
        }
        if (object instanceof Set) {
            HashSet<String> set = new HashSet<String>(((Set)object).size());
            for (Object item : (Set)object) {
                set.add(this.convertToString(item));
            }
            return ((Object)set).toString() + " as Set";
        }
        if (object instanceof List) {
            ArrayList<String> list = new ArrayList<String>(((List)object).size());
            for (Object item : (List)object) {
                list.add(this.convertToString(item));
            }
            return ((Object)list).toString();
        }
        if (object instanceof Map) {
            StringBuilder map = new StringBuilder("[");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                map.append("(").append(this.convertToString(entry.getKey())).append("):(").append(this.convertToString(entry.getValue())).append("),");
            }
            map.deleteCharAt(map.length() - 1);
            return map.append("]").toString();
        }
        if (object instanceof Long) {
            return object + "L";
        }
        if (object instanceof Double) {
            return object + "d";
        }
        if (object instanceof Float) {
            return object + "f";
        }
        if (object instanceof Integer) {
            return "(int) " + object;
        }
        if (object instanceof Class) {
            return ((Class)object).getCanonicalName();
        }
        if (object instanceof P) {
            return this.convertPToString((P)object, new StringBuilder()).toString();
        }
        if (object instanceof SackFunctions.Barrier) {
            return "SackFunctions.Barrier." + object.toString();
        }
        if (object instanceof VertexProperty.Cardinality) {
            return "VertexProperty.Cardinality." + object.toString();
        }
        if (object instanceof TraversalOptionParent.Pick) {
            return "TraversalOptionParent.Pick." + object.toString();
        }
        if (object instanceof Enum) {
            return ((Enum)object).getDeclaringClass().getSimpleName() + "." + object.toString();
        }
        if (object instanceof Element) {
            return this.convertToString(((Element)object).id());
        }
        if (object instanceof Lambda) {
            String lambdaString = ((Lambda)object).getLambdaScript().trim();
            return lambdaString.startsWith("{") ? lambdaString : "{" + lambdaString + "}";
        }
        if (object instanceof TraversalStrategyProxy) {
            TraversalStrategyProxy proxy = (TraversalStrategyProxy)object;
            if (proxy.getConfiguration().isEmpty()) {
                return proxy.getStrategyClass().getCanonicalName() + ".instance()";
            }
            return proxy.getStrategyClass().getCanonicalName() + ".create(new org.apache.commons.configuration.MapConfiguration(" + this.convertToString(ConfigurationConverter.getMap((Configuration)proxy.getConfiguration())) + "))";
        }
        if (object instanceof TraversalStrategy) {
            return this.convertToString(new TraversalStrategyProxy((TraversalStrategy)object));
        }
        return null == object ? "null" : object.toString();
    }

    private StringBuilder convertPToString(P p, StringBuilder current) {
        if (p instanceof ConnectiveP) {
            List list = ((ConnectiveP)p).getPredicates();
            for (int i = 0; i < list.size(); ++i) {
                this.convertPToString((P)list.get(i), current);
                if (i >= list.size() - 1) continue;
                current.append(p instanceof OrP ? ".or(" : ".and(");
            }
            current.append(")");
        } else {
            current.append("P.").append(p.getBiPredicate().toString()).append("(").append(this.convertToString(p.getValue())).append(")");
        }
        return current;
    }
}

