/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import groovy.grape.Grape;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.lang.Tuple;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.EmptyImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.ImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.NoImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.CompilationOptionsCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ConfigurationGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.DependencyManager;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyClassLoader;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslator;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ImportGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.InterpreterModeGroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ManagedConcurrentValueMap;
import org.apache.tinkerpop.gremlin.groovy.jsr223.ScriptEnginePluginAcceptor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.CompilationOptionsCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.ConfigurationCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.InterpreterModeCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.loaders.GremlinLoader;
import org.apache.tinkerpop.gremlin.groovy.plugin.Artifact;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPluginException;
import org.apache.tinkerpop.gremlin.jsr223.CoreGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptContext;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.ImportCustomizer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.util.ReferenceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinGroovyScriptEngine
extends GroovyScriptEngineImpl
implements DependencyManager,
AutoCloseable,
GremlinScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(GremlinGroovyScriptEngine.class);
    public static final String COMPILE_OPTIONS_VAR_TYPES = "sandbox.bindings";
    public static final String KEY_REFERENCE_TYPE = "#jsr223.groovy.engine.keep.globals";
    public static final String REFERENCE_TYPE_PHANTOM = "phantom";
    public static final String REFERENCE_TYPE_WEAK = "weak";
    public static final String REFERENCE_TYPE_SOFT = "soft";
    public static final String REFERENCE_TYPE_HARD = "hard";
    public static final String COLLECTED_BOUND_VARS_MAP_VARNAME = "gremlin_script_engine_collected_boundvars";
    private static final Pattern patternImportStatic = Pattern.compile("\\Aimport\\sstatic.*");
    public static final ThreadLocal<Map<String, Object>> COMPILE_OPTIONS = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private GremlinGroovyClassLoader loader;
    private final LoadingCache<String, Future<Class>> classMap = Caffeine.newBuilder().softValues().recordStats().build((CacheLoader)new CacheLoader<String, Future<Class>>(){

        public Future<Class> load(String script) throws Exception {
            long start = System.currentTimeMillis();
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Class clazz = GremlinGroovyScriptEngine.this.loader.parseClass(script, GremlinGroovyScriptEngine.this.generateScriptName());
                    return clazz;
                }
                catch (CompilationFailedException e) {
                    long finish = System.currentTimeMillis();
                    log.error("Script compilation FAILED {} took {}ms {}", new Object[]{script, finish - start, e});
                    GremlinGroovyScriptEngine.this.failedCompilationCount.incrementAndGet();
                    throw e;
                }
                finally {
                    long time = System.currentTimeMillis() - start;
                    if (time > GremlinGroovyScriptEngine.this.expectedCompilationTime) {
                        log.warn("Script compilation {} took {}ms", (Object)script, (Object)time);
                        GremlinGroovyScriptEngine.this.longRunCompilationCount.incrementAndGet();
                    } else {
                        log.debug("Script compilation {} took {}ms", (Object)script, (Object)time);
                    }
                }
            }, Runnable::run);
        }
    });
    private final ManagedConcurrentValueMap<String, Closure> globalClosures = new ManagedConcurrentValueMap(ReferenceBundle.getHardBundle());
    private static final AtomicLong scriptNameCounter = new AtomicLong(0L);
    private final AtomicLong longRunCompilationCount = new AtomicLong(0L);
    private final AtomicLong failedCompilationCount = new AtomicLong(0L);
    private final Set<String> loadedPlugins = new HashSet<String>();
    private volatile GremlinGroovyScriptEngineFactory factory;
    private static final String STATIC = "static";
    private static final String SCRIPT = "Script";
    private static final String DOT_GROOVY = ".groovy";
    private static final String GROOVY_LANG_SCRIPT = "groovy.lang.Script";
    private ImportCustomizerProvider importCustomizerProvider;
    private final List<CompilerCustomizerProvider> customizerProviders;
    private final ImportGroovyCustomizer importGroovyCustomizer;
    private final List<GroovyCustomizer> groovyCustomizers;
    private final Set<Artifact> artifactsToUse = new HashSet<Artifact>();
    private final boolean interpreterModeEnabled;
    private final long expectedCompilationTime;

    public GremlinGroovyScriptEngine() {
        this(new Customizer[0]);
    }

    @Deprecated
    public GremlinGroovyScriptEngine(ImportCustomizerProvider importCustomizerProvider) {
        this(new CompilerCustomizerProvider[]{importCustomizerProvider});
    }

    public GremlinGroovyScriptEngine(Customizer ... customizers) {
        ArrayList<Customizer> listOfCustomizers = new ArrayList<Customizer>(Arrays.asList(customizers));
        CoreGremlinPlugin.instance().getCustomizers("gremlin-groovy").ifPresent(c -> listOfCustomizers.addAll(Arrays.asList(c)));
        GremlinLoader.load();
        List<ImportCustomizer> importCustomizers = listOfCustomizers.stream().filter(p -> p instanceof ImportCustomizer).map(p -> (ImportCustomizer)p).collect(Collectors.toList());
        ImportCustomizer[] importCustomizerArray = new ImportCustomizer[importCustomizers.size()];
        this.importGroovyCustomizer = new ImportGroovyCustomizer(importCustomizers.toArray(importCustomizerArray));
        this.groovyCustomizers = listOfCustomizers.stream().filter(p -> p instanceof GroovyCustomizer).map(p -> (GroovyCustomizer)p).collect(Collectors.toList());
        Optional<CompilationOptionsCustomizer> compilationOptionsCustomizerProvider = listOfCustomizers.stream().filter(p -> p instanceof CompilationOptionsCustomizer).map(p -> (CompilationOptionsCustomizer)p).findFirst();
        this.expectedCompilationTime = compilationOptionsCustomizerProvider.isPresent() ? compilationOptionsCustomizerProvider.get().getExpectedCompilationTime() : 5000L;
        this.interpreterModeEnabled = this.groovyCustomizers.stream().anyMatch(p -> p.getClass().equals(InterpreterModeGroovyCustomizer.class));
        this.customizerProviders = Collections.emptyList();
        this.createClassLoader();
    }

    @Deprecated
    public GremlinGroovyScriptEngine(CompilerCustomizerProvider ... compilerCustomizerProviders) {
        List<CompilerCustomizerProvider> providers = Arrays.asList(compilerCustomizerProviders);
        GremlinLoader.load();
        this.importCustomizerProvider = providers.stream().filter(p -> p instanceof ImportCustomizerProvider).map(p -> (ImportCustomizerProvider)p).findFirst().orElse(NoImportCustomizerProvider.INSTANCE);
        this.interpreterModeEnabled = providers.stream().anyMatch(p -> p.getClass().equals(InterpreterModeCustomizerProvider.class));
        Optional<CompilationOptionsCustomizerProvider> compilationOptionsCustomizerProvider = providers.stream().filter(p -> p instanceof CompilationOptionsCustomizerProvider).map(p -> (CompilationOptionsCustomizerProvider)p).findFirst();
        this.expectedCompilationTime = compilationOptionsCustomizerProvider.isPresent() ? compilationOptionsCustomizerProvider.get().getExpectedCompilationTime() : 5000L;
        this.customizerProviders = providers.stream().filter(p -> p != null && !(p instanceof ImportCustomizerProvider) && !(p instanceof CompilationOptionsCustomizerProvider)).collect(Collectors.toList());
        this.groovyCustomizers = Collections.emptyList();
        this.importGroovyCustomizer = null;
        this.createClassLoader();
    }

    @Override
    public synchronized List<GremlinPlugin> use(final String group, final String artifact, final String version) {
        HashMap<String, Object> dependency = new HashMap<String, Object>(){
            {
                this.put("group", group);
                this.put("module", artifact);
                this.put("version", version);
            }
        };
        HashMap<String, Object> args = new HashMap<String, Object>(){
            {
                this.put("classLoader", GremlinGroovyScriptEngine.this.loader);
            }
        };
        Grape.grab((Map)args, (Map[])new Map[]{dependency});
        ArrayList<GremlinPlugin> pluginsFound = new ArrayList<GremlinPlugin>();
        ServiceLoader.load(GremlinPlugin.class, (ClassLoader)((Object)this.loader)).forEach(pluginsFound::add);
        this.artifactsToUse.add(new Artifact(group, artifact, version));
        return pluginsFound;
    }

    @Override
    public void loadPlugins(List<GremlinPlugin> plugins) throws GremlinPluginException {
        for (GremlinPlugin gremlinPlugin : plugins) {
            if (this.loadedPlugins.contains(gremlinPlugin.getName())) continue;
            gremlinPlugin.pluginTo(new ScriptEnginePluginAcceptor((ScriptEngine)((Object)this)));
            this.loadedPlugins.add(gremlinPlugin.getName());
        }
    }

    @Override
    public Map[] dependencies() {
        return Grape.listDependencies((ClassLoader)((Object)this.loader));
    }

    @Override
    public Map<String, Set<String>> imports() {
        HashMap<String, Set<String>> m = new HashMap<String, Set<String>>();
        m.put("imports", this.importCustomizerProvider.getImports());
        m.put("staticImports", this.importCustomizerProvider.getStaticImports());
        m.put("extraImports", this.importCustomizerProvider.getExtraImports());
        m.put("extraStaticImports", this.importCustomizerProvider.getExtraStaticImports());
        return m;
    }

    @Override
    public synchronized void addImports(Set<String> importStatements) {
        if (null == this.importCustomizerProvider) {
            throw new IllegalStateException("Imports cannot be added to a GremlinGroovyScriptEngine that uses Customizer instances");
        }
        HashSet<String> staticImports = new HashSet<String>();
        HashSet<String> imports = new HashSet<String>();
        importStatements.forEach(s -> {
            String trimmed = s.trim();
            if (patternImportStatic.matcher(trimmed).matches()) {
                int pos = trimmed.indexOf(STATIC);
                staticImports.add(s.substring(pos + 6).trim());
            } else {
                imports.add(s.substring(6).trim());
            }
        });
        this.importCustomizerProvider = new EmptyImportCustomizerProvider(this.importCustomizerProvider, imports, staticImports);
        this.internalReset();
    }

    @Deprecated
    public Set plugins() {
        return this.loadedPlugins;
    }

    public Set getPlugins() {
        return this.loadedPlugins;
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings bindings) throws ScriptException {
        bindings.putAll(bytecode.getBindings());
        String traversalSource = "g";
        for (Map.Entry entry : bindings.entrySet()) {
            if (!(entry.getValue() instanceof TraversalSource)) continue;
            traversalSource = (String)entry.getKey();
            break;
        }
        return (Traversal.Admin)this.eval(GroovyTranslator.of(traversalSource).translate(bytecode), bindings);
    }

    @Override
    @Deprecated
    public void close() throws Exception {
    }

    @Override
    public void reset() {
        this.internalReset();
        this.loadedPlugins.clear();
        this.getContext().getBindings(100).clear();
    }

    protected ScriptContext getScriptContext(Bindings nn) {
        GremlinScriptContext ctxt = new GremlinScriptContext(this.context.getReader(), this.context.getWriter(), this.context.getErrorWriter());
        Bindings gs = this.getBindings(200);
        if (gs != null) {
            ctxt.setBindings(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        ctxt.setBindings(nn, 100);
        return ctxt;
    }

    private void internalReset() {
        this.createClassLoader();
        this.classMap.invalidateAll();
        this.globalClosures.clear();
        HashSet<Artifact> toReuse = new HashSet<Artifact>(this.artifactsToUse);
        toReuse.forEach(this::use);
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        try {
            String val = (String)context.getAttribute(KEY_REFERENCE_TYPE, 100);
            ReferenceBundle bundle = ReferenceBundle.getHardBundle();
            if (val != null && val.length() > 0) {
                if (val.equalsIgnoreCase(REFERENCE_TYPE_SOFT)) {
                    bundle = ReferenceBundle.getSoftBundle();
                } else if (val.equalsIgnoreCase(REFERENCE_TYPE_WEAK)) {
                    bundle = ReferenceBundle.getWeakBundle();
                } else if (val.equalsIgnoreCase(REFERENCE_TYPE_PHANTOM)) {
                    bundle = ReferenceBundle.getPhantomBundle();
                }
            }
            this.globalClosures.setBundle(bundle);
        }
        catch (ClassCastException val) {
            // empty catch block
        }
        try {
            this.registerBindingTypes(context);
            Class clazz = this.getScriptClass(script);
            if (null == clazz) {
                throw new ScriptException("Script class is null");
            }
            return this.eval(clazz, context);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GremlinScriptEngineFactory getFactory() {
        if (this.factory == null) {
            GremlinGroovyScriptEngine gremlinGroovyScriptEngine = this;
            synchronized (gremlinGroovyScriptEngine) {
                if (this.factory == null) {
                    this.factory = new GremlinGroovyScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public CompiledScript compile(String scriptSource) throws ScriptException {
        try {
            return new GroovyCompiledScript((GroovyScriptEngineImpl)this, this.getScriptClass(scriptSource));
        }
        catch (CompilationFailedException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("Script object can not be null");
        }
        return this.invokeImpl(thiz, name, args);
    }

    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    public <T> T getInterface(Object thiz, Class<T> clazz) {
        if (null == thiz) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(thiz, clazz);
    }

    public long getClassCacheLongRunCompilationCount() {
        return this.longRunCompilationCount.longValue();
    }

    public long getClassCacheEstimatedSize() {
        return this.classMap.estimatedSize();
    }

    public double getClassCacheAverageLoadPenalty() {
        return this.classMap.stats().averageLoadPenalty();
    }

    public long getClassCacheEvictionCount() {
        return this.classMap.stats().evictionCount();
    }

    public long getClassCacheEvictionWeight() {
        return this.classMap.stats().evictionWeight();
    }

    public long getClassCacheHitCount() {
        return this.classMap.stats().hitCount();
    }

    public double getClassCacheHitRate() {
        return this.classMap.stats().hitRate();
    }

    public long getClassCacheLoadCount() {
        return this.classMap.stats().loadCount();
    }

    public long getClassCacheLoadFailureCount() {
        return this.failedCompilationCount.longValue();
    }

    public double getClassCacheLoadFailureRate() {
        long totalLoadCount = this.classMap.stats().loadCount();
        return totalLoadCount == 0L ? 0.0 : (double)this.failedCompilationCount.longValue() / (double)totalLoadCount;
    }

    public long getClassCacheLoadSuccessCount() {
        return this.classMap.stats().loadCount() - this.failedCompilationCount.longValue();
    }

    public long getClassCacheMissCount() {
        return this.classMap.stats().missCount();
    }

    public double getClassCacheMissRate() {
        return this.classMap.stats().missRate();
    }

    public long getClassCacheRequestCount() {
        return this.classMap.stats().missCount();
    }

    public long getClassCacheTotalLoadTime() {
        return this.classMap.stats().totalLoadTime();
    }

    Class getScriptClass(String script) throws CompilationFailedException {
        try {
            return (Class)((Future)this.classMap.get((Object)script)).get();
        }
        catch (ExecutionException e) {
            throw (CompilationFailedException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    boolean isCached(String script) {
        return this.classMap.getIfPresent((Object)script) != null;
    }

    Object eval(Class scriptClass, final ScriptContext context) throws ScriptException {
        Binding binding = new Binding(context.getBindings(100)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getVariable(String name) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    Writer writer;
                    int scope = context.getAttributesScope(name);
                    if (scope != -1) {
                        return context.getAttribute(name, scope);
                    }
                    if ("out".equals(name) && (writer = context.getWriter()) != null) {
                        return writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
                    }
                    if ("context".equals(name)) {
                        return context;
                    }
                }
                throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setVariable(String name, Object value) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    context.setAttribute(name, value, scope);
                }
            }
        };
        try {
            Map localVars;
            if (!Script.class.isAssignableFrom(scriptClass)) {
                return scriptClass;
            }
            Script scriptObject = InvokerHelper.createScript((Class)scriptClass, (Binding)binding);
            for (Method m : scriptClass.getMethods()) {
                String name = m.getName();
                this.globalClosures.put(name, (Closure)new MethodClosure((Object)scriptObject, name));
            }
            MetaClass oldMetaClass = scriptObject.getMetaClass();
            scriptObject.setMetaClass((MetaClass)new DelegatingMetaClass(oldMetaClass){

                public Object invokeMethod(Object object, String name, Object args) {
                    if (args == null) {
                        return this.invokeMethod(object, name, MetaClassHelper.EMPTY_ARRAY);
                    }
                    if (args instanceof Tuple) {
                        return this.invokeMethod(object, name, ((Tuple)args).toArray());
                    }
                    if (args instanceof Object[]) {
                        return this.invokeMethod(object, name, (Object[])args);
                    }
                    return this.invokeMethod(object, name, new Object[]{args});
                }

                public Object invokeMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }

                public Object invokeStaticMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeStaticMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }
            });
            Object o = scriptObject.run();
            if (this.interpreterModeEnabled && (localVars = (Map)context.getAttribute(COLLECTED_BOUND_VARS_MAP_VARNAME)) != null) {
                localVars.entrySet().forEach(e -> {
                    if (e.getValue() instanceof Closure) {
                        this.globalClosures.put((String)e.getKey(), (Closure)e.getValue());
                    }
                    context.setAttribute((String)e.getKey(), e.getValue(), 100);
                });
                context.removeAttribute(COLLECTED_BOUND_VARS_MAP_VARNAME, 100);
                localVars.clear();
            }
            return o;
        }
        catch (Exception e2) {
            throw new ScriptException(e2);
        }
    }

    private void registerBindingTypes(ScriptContext context) {
        HashMap variableTypes = new HashMap();
        GremlinGroovyScriptEngine.clearVarTypes();
        context.getBindings(100).forEach((k, v) -> {
            ClassNode cfr_ignored_0 = variableTypes.put(k, null == v ? null : ClassHelper.make(v.getClass()));
        });
        COMPILE_OPTIONS.get().put(COMPILE_OPTIONS_VAR_TYPES, variableTypes);
    }

    private static void clearVarTypes() {
        Map<String, Object> m = COMPILE_OPTIONS.get();
        if (m.containsKey(COMPILE_OPTIONS_VAR_TYPES)) {
            ((Map)m.get(COMPILE_OPTIONS_VAR_TYPES)).clear();
        }
    }

    private Object invokeImpl(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("Method name can not be null");
        }
        try {
            if (thiz != null) {
                return InvokerHelper.invokeMethod((Object)thiz, (String)name, (Object)args);
            }
        }
        catch (MissingMethodException mme) {
            throw new NoSuchMethodException(mme.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.callGlobal(name, args);
    }

    private synchronized void createClassLoader() {
        if (this.groovyCustomizers.isEmpty() && null == this.importGroovyCustomizer) {
            CompilerConfiguration conf = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
            conf.addCompilationCustomizers(new CompilationCustomizer[]{this.importCustomizerProvider.create()});
            this.customizerProviders.stream().filter(cp -> !(cp instanceof ConfigurationCustomizerProvider)).forEach(p -> conf.addCompilationCustomizers(new CompilationCustomizer[]{p.create()}));
            this.customizerProviders.stream().filter(cp -> cp instanceof ConfigurationCustomizerProvider).findFirst().ifPresent(cp -> ((ConfigurationCustomizerProvider)cp).applyCustomization(conf));
            this.loader = new GremlinGroovyClassLoader(this.getParentLoader(), conf);
        } else {
            CompilerConfiguration conf = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
            conf.addCompilationCustomizers(new CompilationCustomizer[]{this.importGroovyCustomizer.create()});
            this.groovyCustomizers.stream().filter(cp -> !(cp instanceof ConfigurationGroovyCustomizer)).forEach(p -> conf.addCompilationCustomizers(new CompilationCustomizer[]{p.create()}));
            this.groovyCustomizers.stream().filter(cp -> cp instanceof ConfigurationGroovyCustomizer).findFirst().ifPresent(cp -> ((ConfigurationGroovyCustomizer)cp).applyCustomization(conf));
            this.loader = new GremlinGroovyClassLoader(this.getParentLoader(), conf);
        }
    }

    private void use(Artifact artifact) {
        this.use(artifact.getGroup(), artifact.getArtifact(), artifact.getVersion());
    }

    private Object callGlobal(String name, Object[] args) {
        return this.callGlobal(name, args, this.context);
    }

    private Object callGlobal(String name, Object[] args, ScriptContext ctx) {
        Closure closure = this.globalClosures.get(name);
        if (closure != null) {
            return closure.call(args);
        }
        Object value = ctx.getAttribute(name);
        if (value instanceof Closure) {
            return ((Closure)value).call(args);
        }
        throw new MissingMethodException(name, this.getClass(), args);
    }

    private synchronized String generateScriptName() {
        return SCRIPT + scriptNameCounter.incrementAndGet() + DOT_GROOVY;
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (null == clazz || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, m, args) -> this.invokeImpl(obj, m.getName(), args));
    }

    protected ClassLoader getParentLoader() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = ctxtLoader.loadClass(GROOVY_LANG_SCRIPT);
            if (c == Script.class) {
                return ctxtLoader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Script.class.getClassLoader();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }
}

