/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.engine;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.DependencyManager;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.ConfigurationCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.plugin.GremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import org.apache.tinkerpop.gremlin.jsr223.DefaultGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScriptEngines
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ScriptEngines.class);
    private static final GremlinScriptEngineManager SCRIPT_ENGINE_MANAGER = new DefaultGremlinScriptEngineManager();
    private static final GremlinGroovyScriptEngineFactory gremlinGroovyScriptEngineFactory = new GremlinGroovyScriptEngineFactory();
    private final Map<String, GremlinScriptEngine> scriptEngines = new ConcurrentHashMap<String, GremlinScriptEngine>();
    private final AtomicBoolean controlOperationExecuting = new AtomicBoolean(false);
    private final Queue<Thread> controlWaiters = new ConcurrentLinkedQueue<Thread>();
    private final Queue<Thread> evalWaiters = new ConcurrentLinkedQueue<Thread>();
    private final Consumer<ScriptEngines> initializer;

    public ScriptEngines(Consumer<ScriptEngines> initializer) {
        this.initializer = initializer;
        this.initializer.accept(this);
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings bindings, String language) throws ScriptException {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException(String.format("Language [%s] not supported", language));
        }
        this.awaitControlOp();
        GremlinScriptEngine engine = this.scriptEngines.get(language);
        Bindings all = ScriptEngines.mergeBindings(bindings, (ScriptEngine)engine);
        return engine.eval(bytecode, all);
    }

    public Object eval(String script, Bindings bindings, String language) throws ScriptException {
        this.checkLanguageIsSupported(language);
        this.awaitControlOp();
        ScriptEngine engine = (ScriptEngine)this.scriptEngines.get(language);
        Bindings all = ScriptEngines.mergeBindings(bindings, engine);
        return engine.eval(script, all);
    }

    public Object eval(Reader reader, Bindings bindings, String language) throws ScriptException {
        this.checkLanguageIsSupported(language);
        this.awaitControlOp();
        ScriptEngine engine = (ScriptEngine)this.scriptEngines.get(language);
        Bindings all = ScriptEngines.mergeBindings(bindings, engine);
        return engine.eval(reader, all);
    }

    public CompiledScript compile(String script, String language) throws ScriptException {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException("Language [%s] not supported");
        }
        this.awaitControlOp();
        ScriptEngine scriptEngine = (ScriptEngine)this.scriptEngines.get(language);
        if (!Compilable.class.isAssignableFrom(scriptEngine.getClass())) {
            throw new UnsupportedOperationException(String.format("ScriptEngine for %s does not implement %s", language, Compilable.class.getName()));
        }
        Compilable compilable = (Compilable)((Object)scriptEngine);
        return compilable.compile(script);
    }

    public CompiledScript compile(Reader script, String language) throws ScriptException {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException("Language [%s] not supported");
        }
        this.awaitControlOp();
        ScriptEngine scriptEngine = (ScriptEngine)this.scriptEngines.get(language);
        if (scriptEngine instanceof Compilable) {
            throw new UnsupportedOperationException(String.format("ScriptEngine for %s does not implement %s", language, Compilable.class.getName()));
        }
        Compilable compilable = (Compilable)((Object)scriptEngine);
        return compilable.compile(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String language, Set<String> imports, Set<String> staticImports, Map<String, Object> config) {
        try {
            this.signalControlOpStart();
            if (this.scriptEngines.containsKey(language)) {
                this.scriptEngines.remove(language);
            }
            GremlinScriptEngine scriptEngine = ScriptEngines.createScriptEngine(language, imports, staticImports, config).orElseThrow(() -> new IllegalArgumentException(String.format("Language [%s] not supported", language)));
            this.scriptEngines.put(language, scriptEngine);
            logger.info("Loaded {} ScriptEngine", (Object)language);
        }
        finally {
            this.signalControlOpEnd();
        }
    }

    public void addImports(Set<String> imports) {
        try {
            this.signalControlOpStart();
            this.getDependencyManagers().forEach(dm -> dm.addImports(imports));
        }
        finally {
            this.signalControlOpEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GremlinPlugin> use(String group, String artifact, String version) {
        ArrayList<GremlinPlugin> pluginsToLoad = new ArrayList<GremlinPlugin>();
        try {
            this.signalControlOpStart();
            this.getDependencyManagers().forEach(dm -> {
                try {
                    pluginsToLoad.addAll(dm.use(group, artifact, version));
                }
                catch (Exception ex) {
                    logger.warn("Could not get dependency for [{}, {}, {}] - {}", new Object[]{group, artifact, version, ex.getMessage()});
                }
            });
        }
        finally {
            this.signalControlOpEnd();
        }
        return pluginsToLoad;
    }

    public void loadPlugins(List<GremlinPlugin> plugins) {
        try {
            this.signalControlOpStart();
            this.getDependencyManagers().forEach(dm -> {
                try {
                    dm.loadPlugins(plugins);
                }
                catch (IllegalEnvironmentException iee) {
                    logger.warn("Some plugins may not have been loaded to {} - {}", (Object)dm.getClass().getSimpleName(), (Object)iee.getMessage());
                }
                catch (Exception ex) {
                    logger.error(String.format("Some plugins may not have been loaded to %s", dm.getClass().getSimpleName()), (Throwable)ex);
                }
            });
        }
        finally {
            this.signalControlOpEnd();
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.signalControlOpStart();
            this.scriptEngines.values().stream().filter(se -> se instanceof AutoCloseable).map(se -> (AutoCloseable)se).forEach(c -> {
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.scriptEngines.clear();
        }
        finally {
            this.signalControlOpEnd();
        }
    }

    public void reset() {
        try {
            this.signalControlOpStart();
            this.getDependencyManagers().forEach(DependencyManager::reset);
        }
        finally {
            this.signalControlOpEnd();
            this.initializer.accept(this);
        }
    }

    public Map<String, List<Map>> dependencies() {
        HashMap<String, List<Map>> m = new HashMap<String, List<Map>>();
        this.scriptEngines.entrySet().stream().filter(kv -> kv.getValue() instanceof DependencyManager).forEach(kv -> m.put((String)kv.getKey(), Arrays.asList(((DependencyManager)kv.getValue()).dependencies())));
        return m;
    }

    public Map<String, List<Map>> imports() {
        HashMap<String, List<Map>> m = new HashMap<String, List<Map>>();
        this.scriptEngines.entrySet().stream().filter(kv -> kv.getValue() instanceof DependencyManager).forEach(kv -> m.put((String)kv.getKey(), Arrays.asList(((DependencyManager)kv.getValue()).imports())));
        return m;
    }

    private Set<DependencyManager> getDependencyManagers() {
        return this.scriptEngines.entrySet().stream().map(Map.Entry::getValue).filter(se -> se instanceof DependencyManager).map(se -> (DependencyManager)se).collect(Collectors.toSet());
    }

    private void signalControlOpStart() {
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this.controlWaiters.add(current);
        while (this.controlWaiters.peek() != current || !this.controlOperationExecuting.compareAndSet(false, true)) {
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        this.controlWaiters.remove();
        if (wasInterrupted) {
            current.interrupt();
        }
    }

    private void signalControlOpEnd() {
        this.controlOperationExecuting.set(false);
        LockSupport.unpark(this.controlWaiters.peek());
        if (this.controlWaiters.size() == 0) {
            Thread t = this.evalWaiters.poll();
            while (t != null) {
                LockSupport.unpark(t);
                t = this.evalWaiters.poll();
            }
        }
    }

    private void awaitControlOp() {
        if (this.controlWaiters.size() > 0 || this.controlOperationExecuting.get()) {
            this.evalWaiters.add(Thread.currentThread());
            LockSupport.park(this);
        }
    }

    private static synchronized Optional<GremlinScriptEngine> createScriptEngine(String language, Set<String> imports, Set<String> staticImports, Map<String, Object> config) {
        if (language.equals(gremlinGroovyScriptEngineFactory.getLanguageName())) {
            ArrayList<DefaultImportCustomizerProvider> providers = new ArrayList<DefaultImportCustomizerProvider>();
            providers.add(new DefaultImportCustomizerProvider(imports, staticImports));
            Map<String, Object> compilerCustomizerProviders = config.getOrDefault("compilerCustomizerProviders", Collections.emptyMap());
            compilerCustomizerProviders.forEach((k, v) -> {
                try {
                    Class<?> providerClass = Class.forName(k);
                    if (v != null && v instanceof List && ((List)v).size() > 0) {
                        List l = (List)v;
                        Object[] args = new Object[l.size()];
                        l.toArray(args);
                        Class[] argClasses = new Class[args.length];
                        Stream.of(args).map(a -> a.getClass()).collect(Collectors.toList()).toArray(argClasses);
                        Optional<Constructor> constructor = Stream.of(providerClass.getConstructors()).filter(c -> c.getParameterCount() == argClasses.length && ScriptEngines.allMatch(c.getParameterTypes(), argClasses)).findFirst();
                        if (!constructor.isPresent()) throw new IllegalStateException(String.format("Could not configure %s with the supplied options %s", ConfigurationCustomizerProvider.class.getName(), Arrays.asList(args)));
                        providers.add((DefaultImportCustomizerProvider)((CompilerCustomizerProvider)constructor.get().newInstance(args)));
                        return;
                    } else {
                        providers.add((DefaultImportCustomizerProvider)((CompilerCustomizerProvider)providerClass.newInstance()));
                    }
                    return;
                }
                catch (Exception ex) {
                    logger.warn(String.format("Could not instantiate CompilerCustomizerProvider implementation [%s].  It will not be applied.", k), (Throwable)ex);
                }
            });
            CompilerCustomizerProvider[] providerArray = new CompilerCustomizerProvider[providers.size()];
            return Optional.of(new GremlinGroovyScriptEngine(providers.toArray(providerArray)));
        }
        return Optional.ofNullable(SCRIPT_ENGINE_MANAGER.getEngineByName(language));
    }

    private static boolean allMatch(Class<?>[] constructorArgTypes, Class<?>[] argTypes) {
        for (int ix = 0; ix < constructorArgTypes.length; ++ix) {
            if (constructorArgTypes[ix].isAssignableFrom(argTypes[ix])) continue;
            return false;
        }
        return true;
    }

    private static Bindings mergeBindings(Bindings bindings, ScriptEngine engine) {
        Bindings global = engine.getBindings(200);
        if (null == global) {
            return bindings;
        }
        SimpleBindings all = new SimpleBindings(global);
        all.putAll(bindings);
        return all;
    }

    private void checkLanguageIsSupported(String language) {
        if (!this.scriptEngines.containsKey(language)) {
            throw new IllegalArgumentException(String.format("Language [%s] not supported", language));
        }
    }
}

