/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.auth;

import org.apache.tinkerpop.gremlin.driver.RequestInterceptor;
import org.apache.tinkerpop.gremlin.driver.Settings;
import org.apache.tinkerpop.gremlin.driver.auth.Basic;
import org.apache.tinkerpop.gremlin.driver.auth.Sigv4;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public interface Auth
extends RequestInterceptor {
    public static final String AUTH_BASIC = "basic";
    public static final String AUTH_SIGV4 = "sigv4";

    public static Auth basic(String username, String password) {
        return new Basic(username, password);
    }

    public static Auth sigv4(String regionName, String serviceName) {
        return new Sigv4(regionName, serviceName);
    }

    public static Auth sigv4(String regionName, AwsCredentialsProvider awsCredentialsProvider, String serviceName) {
        return new Sigv4(regionName, awsCredentialsProvider, serviceName);
    }

    public static Auth from(Settings.AuthSettings settings) {
        if (settings.type.equals(AUTH_BASIC)) {
            return Auth.basic(settings.username, settings.password);
        }
        if (settings.type.equals(AUTH_SIGV4)) {
            return Auth.sigv4(settings.region, settings.serviceName);
        }
        throw new IllegalArgumentException("Unknown auth type: " + settings.type);
    }

    public static class AuthenticationException
    extends RuntimeException {
        public AuthenticationException(Exception cause) {
            super(cause);
        }
    }
}

