/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ZoneOffsetSerializer
extends SimpleTypeSerializer<ZoneOffset> {
    public ZoneOffsetSerializer() {
        super(DataType.ZONEOFFSET);
    }

    @Override
    protected ZoneOffset readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return ZoneOffset.ofTotalSeconds(buffer.readInt());
    }

    @Override
    protected void writeValue(ZoneOffset value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.getTotalSeconds());
    }
}

