/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.Duration;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class DurationSerializer
extends SimpleTypeSerializer<Duration> {
    public DurationSerializer() {
        super(DataType.DURATION);
    }

    @Override
    protected Duration readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return Duration.ofSeconds(buffer.readLong(), buffer.readInt());
    }

    @Override
    protected void writeValue(Duration value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeLong(value.getSeconds()).writeInt(value.getNano());
    }
}

