/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializer;

public abstract class SimpleTypeSerializer<T>
implements TypeSerializer<T> {
    private final DataType dataType;

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public SimpleTypeSerializer(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public T read(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return this.readValue(buffer, context, true);
    }

    @Override
    public T readValue(ByteBuf buffer, GraphBinaryReader context, boolean nullable) throws SerializationException {
        byte valueFlag;
        if (nullable && ((valueFlag = buffer.readByte()) & 1) == 1) {
            return null;
        }
        return this.readValue(buffer, context);
    }

    abstract T readValue(ByteBuf var1, GraphBinaryReader var2) throws SerializationException;

    @Override
    public ByteBuf write(T value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return this.writeValue(value, allocator, context, true);
    }

    @Override
    public ByteBuf writeValue(T value, ByteBufAllocator allocator, GraphBinaryWriter context, boolean nullable) throws SerializationException {
        if (value == null) {
            if (!nullable) {
                throw new SerializationException("Unexpected null value when nullable is false");
            }
            return context.getValueFlagNull();
        }
        ByteBuf valueSequence = this.writeValue(value, allocator, context);
        if (!nullable) {
            return valueSequence;
        }
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{context.getValueFlagNone(), valueSequence});
    }

    public abstract ByteBuf writeValue(T var1, ByteBufAllocator var2, GraphBinaryWriter var3) throws SerializationException;
}

