/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class LocalDateTimeSerializer
extends SimpleTypeSerializer<LocalDateTime> {
    public LocalDateTimeSerializer() {
        super(DataType.LOCALDATETIME);
    }

    @Override
    LocalDateTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return LocalDateTime.of(context.readValue(buffer, LocalDate.class, false), context.readValue(buffer, LocalTime.class, false));
    }

    @Override
    public ByteBuf writeValue(LocalDateTime value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.toLocalDate(), allocator, false));
        result.addComponent(true, context.writeValue(value.toLocalTime(), allocator, false));
        return result;
    }
}

