/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

class CollectionSerializer
extends SimpleTypeSerializer<Collection> {
    public CollectionSerializer(DataType dataType) {
        super(dataType);
    }

    @Override
    Collection readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        ArrayList result = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            result.add(context.read(buffer));
        }
        return result;
    }

    @Override
    public ByteBuf writeValue(Collection value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(1 + value.size());
        result.addComponent(true, allocator.buffer(4).writeInt(value.size()));
        for (Object item : value) {
            result.addComponent(true, context.write(item, allocator));
        }
        return result;
    }
}

