/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseResult;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatus;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;

public class ResponseMessageSerializer {
    public ResponseMessage readValue(ByteBuf buffer, GraphBinaryReader context, boolean nullable) throws SerializationException {
        byte version = buffer.readByte();
        assert (version >>> 31 == 1);
        return ResponseMessage.build(context.readValue(buffer, UUID.class, true)).code(ResponseStatusCode.getFromValue(context.readValue(buffer, Integer.class, false))).statusMessage(context.readValue(buffer, String.class, true)).statusAttributes(context.readValue(buffer, Map.class, false)).responseMetaData(context.readValue(buffer, Map.class, false)).result(context.read(buffer)).create();
    }

    public ByteBuf writeValue(ResponseMessage value, ByteBufAllocator allocator, GraphBinaryWriter context, boolean nullable) throws SerializationException {
        ResponseResult result = value.getResult();
        ResponseStatus status = value.getStatus();
        return allocator.compositeBuffer(8).addComponents(true, new ByteBuf[]{allocator.buffer(1).writeByte(129), context.writeValue(value.getRequestId(), allocator, true), context.writeValue(status.getCode().getValue(), allocator, false), context.writeValue(status.getMessage(), allocator, true), context.writeValue(status.getAttributes(), allocator, false), context.writeValue(result.getMeta(), allocator, false), context.write(result.getData(), allocator)});
    }
}

