/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryIo;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.RequestMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.ResponseMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.javatuples.Pair;

public class GraphBinaryMessageSerializerV1
extends AbstractMessageSerializer {
    public static final String TOKEN_CUSTOM = "custom";
    private static final String MIME_TYPE = "application/vnd.graphbinary-v1.0";
    private static final byte[] HEADER = "application/vnd.graphbinary-v1.0".getBytes(StandardCharsets.UTF_8);
    private GraphBinaryReader reader;
    private GraphBinaryWriter writer;
    private RequestMessageSerializer requestSerializer;
    private ResponseMessageSerializer responseSerializer;

    public GraphBinaryMessageSerializerV1() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryMessageSerializerV1(TypeSerializerRegistry registry) {
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.requestSerializer = new RequestMessageSerializer();
        this.responseSerializer = new ResponseMessageSerializer();
    }

    public GraphBinaryMessageSerializerV1(TypeSerializerRegistry.Builder builder) {
        this(builder.create());
    }

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        List<String> classNameList = this.getListStringFromConfig("ioRegistries", config);
        TypeSerializerRegistry.Builder builder = TypeSerializerRegistry.build();
        classNameList.forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz);
                    IoRegistry ioreg = (IoRegistry)instanceMethod.invoke(null, new Object[0]);
                    List classSerializers = ioreg.find(GraphBinaryIo.class, CustomTypeSerializer.class);
                    for (Pair cs : classSerializers) {
                        builder.addCustomType((Class)cs.getValue0(), (CustomTypeSerializer)cs.getValue1());
                    }
                }
                catch (Exception methodex) {
                    throw new IllegalStateException(String.format("Could not instantiate IoRegistry from an instance() method on %s", className), methodex);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        });
        this.addCustomClasses(config, builder);
        TypeSerializerRegistry registry = builder.create();
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.requestSerializer = new RequestMessageSerializer();
        this.responseSerializer = new ResponseMessageSerializer();
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        return this.responseSerializer.writeValue(responseMessage, allocator, this.writer, false);
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(3);
        result.addComponent(true, allocator.buffer(1).writeByte(HEADER.length));
        result.addComponent(true, allocator.buffer(HEADER.length).writeBytes(HEADER));
        result.addComponent(true, this.requestSerializer.writeValue(requestMessage, allocator, this.writer));
        return result;
    }

    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        return this.requestSerializer.readValue(msg, this.reader);
    }

    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        return this.responseSerializer.readValue(msg, this.reader, false);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE};
    }

    private void addCustomClasses(Map<String, Object> config, TypeSerializerRegistry.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_CUSTOM, config);
        classNameList.forEach(serializerDefinition -> {
            String[] split;
            if (serializerDefinition.contains(";")) {
                split = serializerDefinition.split(";");
                if (split.length != 2) {
                    throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
                }
            } else {
                throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
            }
            String className = split[0];
            String serializerName = split[1];
            try {
                Class<?> clazz = Class.forName(className);
                Class<?> serializerClazz = Class.forName(serializerName);
                CustomTypeSerializer serializer = (CustomTypeSerializer)serializerClazz.newInstance();
                builder.addCustomType(clazz, serializer);
            }
            catch (Exception ex) {
                throw new IllegalStateException("CustomTypeSerializer could not be instantiated", ex);
            }
        });
    }
}

