/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class RequestOptions {
    public static final RequestOptions EMPTY = RequestOptions.build().create();
    private final Map<String, String> aliases;
    private final Map<String, Object> parameters;
    private final Integer batchSize;
    private final Long timeout;

    private RequestOptions(Builder builder) {
        this.aliases = builder.aliases;
        this.parameters = builder.parameters;
        this.batchSize = builder.batchSize;
        this.timeout = builder.timeout;
    }

    public Optional<Map<String, String>> getAliases() {
        return Optional.ofNullable(this.aliases);
    }

    public Optional<Map<String, Object>> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Integer> getBatchSize() {
        return Optional.ofNullable(this.batchSize);
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> aliases = null;
        private Map<String, Object> parameters = null;
        private Integer batchSize = null;
        private Long timeout = null;

        public Builder addAlias(String aliasName, String actualName) {
            if (null == this.aliases) {
                this.aliases = new HashMap<String, String>();
            }
            this.aliases.put(aliasName, actualName);
            return this;
        }

        public Builder addParameter(String name, Object value) {
            if (null == this.parameters) {
                this.parameters = new HashMap<String, Object>();
            }
            this.parameters.put(name, value);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public RequestOptions create() {
            return new RequestOptions(this);
        }
    }
}

