/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;

public class DriverRemoteConnection
implements RemoteConnection {
    public static final String GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE = "gremlin.remoteGraph.driver.clusterFile";
    public static final String GREMLIN_REMOTE_GRAPH_DRIVER_GRAPHNAME = "gremlin.remoteGraph.driver.graphName";
    private static final String DEFAULT_GRAPH = "graph";
    private static final boolean attachElements = Boolean.valueOf(System.getProperty("is.testing", "false"));
    private final Client client;
    private final boolean tryCloseCluster;
    private final String connectionGraphName;
    private transient Optional<Configuration> conf = Optional.empty();

    public DriverRemoteConnection(Configuration conf) {
        if (conf.containsKey(GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE) && conf.containsKey("clusterConfiguration")) {
            throw new IllegalStateException(String.format("A configuration should not contain both '%s' and 'clusterConfiguration'", GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE));
        }
        this.connectionGraphName = conf.getString(GREMLIN_REMOTE_GRAPH_DRIVER_GRAPHNAME, DEFAULT_GRAPH);
        try {
            Cluster cluster = !conf.containsKey(GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE) && !conf.containsKey("clusterConfiguration") ? Cluster.open() : (conf.containsKey(GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE) ? Cluster.open(conf.getString(GREMLIN_REMOTE_GRAPH_DRIVER_CLUSTERFILE)) : Cluster.open(conf.subset("clusterConfiguration")));
            this.client = ((Client)cluster.connect(Client.Settings.build().unrollTraversers(false).create())).alias(this.connectionGraphName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.tryCloseCluster = true;
        this.conf = Optional.of(conf);
    }

    private DriverRemoteConnection(Cluster cluster, boolean tryCloseCluster, String connectionGraphName) {
        this.client = ((Client)cluster.connect(Client.Settings.build().unrollTraversers(false).create())).alias(connectionGraphName);
        this.connectionGraphName = connectionGraphName;
        this.tryCloseCluster = tryCloseCluster;
    }

    DriverRemoteConnection(Cluster cluster, Configuration conf) {
        this.connectionGraphName = conf.getString(GREMLIN_REMOTE_GRAPH_DRIVER_GRAPHNAME, DEFAULT_GRAPH);
        this.client = ((Client)cluster.connect(Client.Settings.build().unrollTraversers(false).create())).alias(this.connectionGraphName);
        this.tryCloseCluster = false;
        this.conf = Optional.of(conf);
    }

    public static DriverRemoteConnection using(Cluster cluster) {
        return DriverRemoteConnection.using(cluster, DEFAULT_GRAPH);
    }

    public static DriverRemoteConnection using(Cluster cluster, String connectionGraphName) {
        return new DriverRemoteConnection(cluster, false, connectionGraphName);
    }

    public static DriverRemoteConnection using(String clusterConfFile) {
        return DriverRemoteConnection.using(clusterConfFile, DEFAULT_GRAPH);
    }

    public static DriverRemoteConnection using(String clusterConfFile, String connectionGraphName) {
        try {
            return new DriverRemoteConnection(Cluster.open(clusterConfFile), true, connectionGraphName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static DriverRemoteConnection using(Configuration conf) {
        if (conf.containsKey("clusterConfigurationFile") && conf.containsKey("clusterConfiguration")) {
            throw new IllegalStateException("A configuration should not contain both 'clusterConfigurationFile' and 'clusterConfiguration'");
        }
        if (!conf.containsKey("clusterConfigurationFile") && !conf.containsKey("clusterConfiguration")) {
            throw new IllegalStateException("A configuration must contain either 'clusterConfigurationFile' and 'clusterConfiguration'");
        }
        String connectionGraphName = conf.getString("connectionGraphName", DEFAULT_GRAPH);
        if (conf.containsKey("clusterConfigurationFile")) {
            return DriverRemoteConnection.using(conf.getString("clusterConfigurationFile"), connectionGraphName);
        }
        return DriverRemoteConnection.using(Cluster.open(conf.subset("clusterConfiguration")), connectionGraphName);
    }

    public <E> Iterator<Traverser.Admin<E>> submit(Traversal<?, E> t) throws RemoteConnectionException {
        try {
            if (attachElements) {
                if (!this.conf.isPresent()) {
                    throw new IllegalStateException("Traverser can't be reattached for testing");
                }
                Graph graph = (Graph)((Supplier)this.conf.get().getProperty("hidden.for.testing.only")).get();
                return new AttachingTraverserIterator(this.client.submit(t).iterator(), graph);
            }
            return new TraverserIterator(this.client.submit(t).iterator());
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
    }

    public void close() throws Exception {
        try {
            this.client.close();
        }
        catch (Exception ex) {
            throw new RemoteConnectionException((Throwable)ex);
        }
        finally {
            if (this.tryCloseCluster) {
                this.client.getCluster().close();
            }
        }
    }

    public String toString() {
        return "DriverServerConnection-" + this.client.getCluster() + " [graph=" + this.connectionGraphName + "]";
    }

    static class AttachingTraverserIterator<E>
    extends TraverserIterator<E> {
        private final Graph graph;

        public AttachingTraverserIterator(Iterator<Result> resultIterator, Graph graph) {
            super(resultIterator);
            this.graph = graph;
        }

        @Override
        public Traverser.Admin<E> next() {
            Traverser.Admin traverser = super.next();
            if (traverser.get() instanceof Attachable && !(traverser.get() instanceof Property)) {
                traverser.set(((Attachable)traverser.get()).attach(Attachable.Method.get((Host)this.graph)));
            }
            return traverser;
        }
    }

    static class TraverserIterator<E>
    implements Iterator<Traverser.Admin<E>> {
        private Iterator<Result> inner;

        public TraverserIterator(Iterator<Result> resultIterator) {
            this.inner = resultIterator;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public Traverser.Admin<E> next() {
            return (Traverser.Admin)this.inner.next().getObject();
        }
    }
}

