/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

final class Settings {
    public int port = 8182;
    public List<String> hosts = new ArrayList<String>();
    public SerializerSettings serializer = new SerializerSettings();
    public ConnectionPoolSettings connectionPool = new ConnectionPoolSettings();
    public int nioPoolSize = Runtime.getRuntime().availableProcessors();
    public int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    public String username = null;
    public String password = null;
    public String jaasEntry = null;
    public String protocol = null;

    Settings() {
    }

    public static Settings read(InputStream stream) {
        Objects.requireNonNull(stream);
        Constructor constructor = new Constructor(Settings.class);
        TypeDescription settingsDescription = new TypeDescription(Settings.class);
        settingsDescription.putListPropertyType("hosts", String.class);
        settingsDescription.putListPropertyType("serializers", SerializerSettings.class);
        constructor.addTypeDescription(settingsDescription);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (Settings)yaml.loadAs(stream, Settings.class);
    }

    public static class SerializerSettings {
        public String className = GryoMessageSerializerV1d0.class.getCanonicalName();
        public Map<String, Object> config = null;

        public MessageSerializer create() throws Exception {
            Class<?> clazz = Class.forName(this.className);
            MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
            Optional.ofNullable(this.config).ifPresent(c -> serializer.configure((Map<String, Object>)c, null));
            return serializer;
        }
    }

    static class ConnectionPoolSettings {
        public boolean enableSsl = false;
        public String trustCertChainFile = null;
        public String keyCertChainFile = null;
        public String keyFile = null;
        public String keyPassword = null;
        public int minSize = 2;
        public int maxSize = 8;
        public int minSimultaneousUsagePerConnection = 8;
        public int maxSimultaneousUsagePerConnection = 16;
        public int maxInProcessPerConnection = 4;
        public int minInProcessPerConnection = 1;
        public int maxWaitForConnection = 3000;
        public int maxWaitForSessionClose = 3000;
        public int maxContentLength = 65536;
        public int reconnectInterval = 1000;
        public int reconnectInitialDelay = 1000;
        public int resultIterationBatchSize = 64;
        public String channelizer = Channelizer.WebSocketChannelizer.class.getName();
        @Deprecated
        public String sessionId = null;

        ConnectionPoolSettings() {
        }

        @Deprecated
        public Optional<String> optionalSessionId() {
            return Optional.ofNullable(this.sessionId);
        }
    }
}

