/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Connection;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    protected final Cluster cluster;
    protected volatile boolean initialized;

    Client(Cluster cluster) {
        this.cluster = cluster;
    }

    public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
        return builder;
    }

    protected abstract void initializeImplementation();

    protected abstract Connection chooseConnection(RequestMessage var1) throws TimeoutException, ConnectionException;

    public abstract CompletableFuture<Void> closeAsync();

    @Deprecated
    public Client rebind(String graphOrTraversalSource) {
        return this.alias(graphOrTraversalSource);
    }

    public Client alias(String graphOrTraversalSource) {
        return new AliasClusteredClient(this, graphOrTraversalSource);
    }

    @Deprecated
    public Client rebind(Map<String, String> rebindings) {
        return this.alias(rebindings);
    }

    public Client alias(Map<String, String> aliases) {
        return new AliasClusteredClient(this, aliases);
    }

    public synchronized Client init() {
        if (this.initialized) {
            return this;
        }
        logger.debug("Initializing client on cluster [{}]", (Object)this.cluster);
        this.cluster.init();
        this.initializeImplementation();
        this.initialized = true;
        return this;
    }

    public ResultSet submit(String gremlin) {
        return this.submit(gremlin, null);
    }

    public ResultSet submit(String gremlin, Map<String, Object> parameters) {
        try {
            return this.submitAsync(gremlin, parameters).get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin) {
        return this.submitAsync(gremlin, null);
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        return this.submitAsync(this.buildMessage(request).create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        if (graphOrTraversalSource != null && !graphOrTraversalSource.isEmpty()) {
            request.addArg("aliases", this.makeAliases(graphOrTraversalSource));
        }
        return this.submitAsync(this.buildMessage(request).create());
    }

    public CompletableFuture<ResultSet> submitAsync(String gremlin, Map<String, String> aliases, Map<String, Object> parameters) {
        RequestMessage.Builder request = RequestMessage.build("eval").add("gremlin", gremlin).add("batchSize", this.cluster.connectionPoolSettings().resultIterationBatchSize);
        Optional.ofNullable(parameters).ifPresent(params -> request.addArg("bindings", parameters));
        if (aliases != null && !aliases.isEmpty()) {
            request.addArg("aliases", aliases);
        }
        return this.submitAsync(this.buildMessage(request).create());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<ResultSet> submitAsync(RequestMessage msg) {
        CompletableFuture<ResultSet> completableFuture;
        if (!this.initialized) {
            this.init();
        }
        CompletableFuture<ResultSet> future = new CompletableFuture<ResultSet>();
        Connection connection = null;
        try {
            connection = this.chooseConnection(msg);
            connection.write(msg, future);
            completableFuture = future;
        }
        catch (TimeoutException toe) {
            try {
                throw new RuntimeException(toe);
                catch (ConnectionException ce) {
                    throw new RuntimeException(ce);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
                }
                throw throwable;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Submitted {} to - {}", (Object)msg, (Object)(null == connection ? "connection not initialized" : connection.toString()));
        }
        return completableFuture;
    }

    public void close() {
        this.closeAsync().join();
    }

    private Map<String, String> makeAliases(String graphOrTraversalSource) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("g", graphOrTraversalSource);
        return aliases;
    }

    public static final class SessionedClient
    extends Client {
        private final String sessionId;
        private final boolean manageTransactions;
        private ConnectionPool connectionPool;

        SessionedClient(Cluster cluster, String sessionId, boolean manageTransactions) {
            super(cluster);
            this.sessionId = sessionId;
            this.manageTransactions = manageTransactions;
        }

        String getSessionId() {
            return this.sessionId;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            builder.processor("session");
            builder.addArg("session", this.sessionId);
            builder.addArg("manageTransaction", this.manageTransactions);
            return builder;
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            return this.connectionPool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void initializeImplementation() {
            List hosts = this.cluster.allHosts().stream().filter(Host::isAvailable).collect(Collectors.toList());
            Collections.shuffle(hosts);
            Host host = (Host)hosts.get(0);
            this.connectionPool = new ConnectionPool(host, this, Optional.of(1), Optional.of(1));
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            return this.connectionPool.closeAsync();
        }
    }

    @Deprecated
    public static class ReboundClusteredClient
    extends Client {
        private final Client client;
        private final Map<String, String> aliases = new HashMap<String, String>();
        final CompletableFuture<Void> close = new CompletableFuture();

        ReboundClusteredClient(Client client, String graphOrTraversalSource) {
            super(client.cluster);
            this.client = client;
            this.aliases.put("g", graphOrTraversalSource);
        }

        ReboundClusteredClient(Client client, Map<String, String> rebindings) {
            super(client.cluster);
            this.client = client;
            this.aliases.putAll(rebindings);
        }

        @Override
        public synchronized Client init() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            this.client.init();
            return this;
        }

        @Override
        public RequestMessage.Builder buildMessage(RequestMessage.Builder builder) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            if (!this.aliases.isEmpty()) {
                builder.addArg("aliases", this.aliases);
            }
            return this.client.buildMessage(builder);
        }

        @Override
        protected void initializeImplementation() {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return this.client.chooseConnection(msg);
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            this.close.complete(null);
            return this.close;
        }

        @Override
        @Deprecated
        public Client rebind(String graphOrTraversalSource) {
            return this.alias(graphOrTraversalSource);
        }

        @Override
        public Client alias(String graphOrTraversalSource) {
            if (this.close.isDone()) {
                throw new IllegalStateException("Client is closed");
            }
            return new AliasClusteredClient(this.client, graphOrTraversalSource);
        }
    }

    public static final class AliasClusteredClient
    extends ReboundClusteredClient {
        public AliasClusteredClient(Client clusteredClient, String graphOrTraversalSource) {
            super(clusteredClient, graphOrTraversalSource);
        }

        public AliasClusteredClient(Client clusteredClient, Map<String, String> rebindings) {
            super(clusteredClient, rebindings);
        }
    }

    public static final class ClusteredClient
    extends Client {
        private ConcurrentMap<Host, ConnectionPool> hostConnectionPools = new ConcurrentHashMap<Host, ConnectionPool>();

        ClusteredClient(Cluster cluster) {
            super(cluster);
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource) {
            return this.submit(gremlin, graphOrTraversalSource, null);
        }

        public ResultSet submit(String gremlin, String graphOrTraversalSource, Map<String, Object> parameters) {
            try {
                return this.submitAsync(gremlin, graphOrTraversalSource, parameters).get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        protected Connection chooseConnection(RequestMessage msg) throws TimeoutException, ConnectionException {
            Iterator<Host> possibleHosts = this.cluster.loadBalancingStrategy().select(msg);
            if (!possibleHosts.hasNext()) {
                throw new TimeoutException("Timed out while waiting for an available host - check the client configuration and connectivity to the server if this message persists");
            }
            Host bestHost = possibleHosts.next();
            ConnectionPool pool = (ConnectionPool)this.hostConnectionPools.get(bestHost);
            return pool.borrowConnection(this.cluster.connectionPoolSettings().maxWaitForConnection, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void initializeImplementation() {
            this.cluster.allHosts().forEach(host -> {
                try {
                    this.hostConnectionPools.put((Host)host, new ConnectionPool((Host)host, this));
                    this.cluster.loadBalancingStrategy().onNew((Host)host);
                }
                catch (Exception ex) {
                    logger.warn("Could not initialize connection pool for {} - will try later", host);
                }
            });
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture[] poolCloseFutures = new CompletableFuture[this.hostConnectionPools.size()];
            this.hostConnectionPools.values().stream().map(ConnectionPool::closeAsync).collect(Collectors.toList()).toArray(poolCloseFutures);
            return CompletableFuture.allOf(poolCloseFutures);
        }
    }
}

