/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;

public class ResultSet
implements Iterable<Result> {
    private final ResultQueue resultQueue;
    private final ExecutorService executor;
    private final Channel channel;
    private final Supplier<Void> onChannelError;

    public ResultSet(ResultQueue resultQueue, ExecutorService executor, Channel channel, Supplier<Void> onChannelError) {
        this.executor = executor;
        this.resultQueue = resultQueue;
        this.channel = channel;
        this.onChannelError = onChannelError;
    }

    public boolean allItemsAvailable() {
        return this.resultQueue.getStatus() == ResultQueue.Status.COMPLETE;
    }

    public int getAvailableItemCount() {
        return this.resultQueue.size();
    }

    public boolean isExhausted() {
        if (!this.resultQueue.isEmpty()) {
            return false;
        }
        this.internalAwaitItems(1);
        assert (!this.resultQueue.isEmpty() || this.allItemsAvailable());
        return this.resultQueue.isEmpty();
    }

    public Result one() {
        Result result = this.resultQueue.poll();
        if (result != null) {
            return result;
        }
        this.internalAwaitItems(1);
        result = this.resultQueue.poll();
        if (result != null) {
            return result;
        }
        return null;
    }

    public CompletableFuture<Integer> awaitItems(int items) {
        if (this.allItemsAvailable()) {
            CompletableFuture.completedFuture(this.getAvailableItemCount());
        }
        return CompletableFuture.supplyAsync(() -> this.internalAwaitItems(items), this.executor);
    }

    public CompletableFuture<List<Result>> all() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Result> list = new ArrayList<Result>();
            while (!this.isExhausted()) {
                Result result = this.resultQueue.poll();
                if (result == null) continue;
                list.add(result);
            }
            return list;
        }, this.executor);
    }

    public Stream<Result> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1088), false);
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){

            @Override
            public boolean hasNext() {
                return !ResultSet.this.isExhausted();
            }

            @Override
            public Result next() {
                return ResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int internalAwaitItems(int items) {
        while (!this.allItemsAvailable() && this.getAvailableItemCount() < items) {
            if (this.channel.isOpen()) continue;
            this.onChannelError.get();
            throw new RuntimeException("Error while processing results from channel - check client and server logs for more information");
        }
        return this.getAvailableItemCount();
    }
}

