/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Result;

class ResultQueue {
    private final LinkedBlockingQueue<Result> resultLinkedBlockingQueue;
    private volatile Status status = Status.FETCHING;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final CompletableFuture<Void> readComplete;

    public ResultQueue(LinkedBlockingQueue<Result> resultLinkedBlockingQueue, CompletableFuture<Void> readComplete) {
        this.resultLinkedBlockingQueue = resultLinkedBlockingQueue;
        this.readComplete = readComplete;
    }

    public void add(Result result) {
        this.resultLinkedBlockingQueue.offer(result);
    }

    public int size() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.resultLinkedBlockingQueue.size();
    }

    public boolean isEmpty() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.size() == 0;
    }

    public Result poll() {
        Result result = null;
        do {
            if (this.error.get() != null) {
                throw new RuntimeException(this.error.get());
            }
            try {
                result = this.resultLinkedBlockingQueue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                this.error.set(new RuntimeException(ie));
            }
        } while (null == result && this.status == Status.FETCHING);
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    void markComplete() {
        this.status = Status.COMPLETE;
        this.readComplete.complete(null);
    }

    void markError(Throwable throwable) {
        this.error.set(throwable);
        this.readComplete.complete(null);
    }

    public static enum Status {
        FETCHING,
        COMPLETE;

    }
}

