/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.Settings;
import org.apache.tinkerpop.gremlin.driver.ser.Serializers;

public class Cluster {
    private Manager manager;

    private Cluster(List<InetSocketAddress> contactPoints, MessageSerializer serializer, int nioPoolSize, int workerPoolSize, Settings.ConnectionPoolSettings connectionPoolSettings, LoadBalancingStrategy loadBalancingStrategy) {
        this.manager = new Manager(contactPoints, serializer, nioPoolSize, workerPoolSize, connectionPoolSettings, loadBalancingStrategy);
    }

    public synchronized void init() {
        if (!this.manager.initialized) {
            this.manager.init();
        }
    }

    public Client connect() {
        return new Client.ClusteredClient(this);
    }

    public Client connect(String sessionId) {
        if (null == sessionId || sessionId.isEmpty()) {
            throw new IllegalArgumentException("sessionId cannot be null or empty");
        }
        return new Client.SessionedClient(this, sessionId);
    }

    public String toString() {
        return this.manager.toString();
    }

    public static Builder build() {
        return new Builder();
    }

    public static Builder build(String address) {
        return new Builder(address);
    }

    public static Builder build(File configurationFile) throws FileNotFoundException {
        Settings settings = Settings.read(new FileInputStream(configurationFile));
        List<String> addresses = settings.hosts;
        if (addresses.size() == 0) {
            throw new IllegalStateException("At least one value must be specified to the hosts setting");
        }
        Builder builder = new Builder(settings.hosts.get(0)).port(settings.port).nioPoolSize(settings.nioPoolSize).workerPoolSize(settings.workerPoolSize).maxInProcessPerConnection(settings.connectionPool.maxInProcessPerConnection).maxSimultaneousUsagePerConnection(settings.connectionPool.maxSimultaneousUsagePerConnection).minSimultaneousUsagePerConnection(settings.connectionPool.minSimultaneousUsagePerConnection).maxConnectionPoolSize(settings.connectionPool.maxSize).minConnectionPoolSize(settings.connectionPool.minSize);
        if (addresses.size() > 1) {
            addresses.stream().skip(1L).forEach(builder::addContactPoint);
        }
        try {
            builder.serializer(settings.serializer.create());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not establish serializer - " + ex.getMessage());
        }
        return builder;
    }

    public static Cluster open() {
        return Cluster.build("localhost").create();
    }

    public static Cluster open(String configurationFile) throws Exception {
        File file = new File(configurationFile);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("Configuration file at %s does not exist", configurationFile));
        }
        return Cluster.build(file).create();
    }

    public void close() {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.manager.close();
    }

    public List<URI> availableHosts() {
        return Collections.unmodifiableList(this.allHosts().stream().filter(Host::isAvailable).map(Host::getHostUri).collect(Collectors.toList()));
    }

    Factory getFactory() {
        return this.manager.factory;
    }

    MessageSerializer getSerializer() {
        return this.manager.serializer;
    }

    ScheduledExecutorService executor() {
        return this.manager.executor;
    }

    Settings.ConnectionPoolSettings connectionPoolSettings() {
        return this.manager.connectionPoolSettings;
    }

    LoadBalancingStrategy loadBalancingStrategy() {
        return this.manager.loadBalancingStrategy;
    }

    Collection<Host> allHosts() {
        return this.manager.allHosts();
    }

    class Manager {
        private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
        private boolean initialized;
        private final List<InetSocketAddress> contactPoints;
        private final Factory factory;
        private final MessageSerializer serializer;
        private final Settings.ConnectionPoolSettings connectionPoolSettings;
        private final LoadBalancingStrategy loadBalancingStrategy;
        private final ScheduledExecutorService executor;

        private Manager(List<InetSocketAddress> contactPoints, MessageSerializer serializer, int nioPoolSize, int workerPoolSize, Settings.ConnectionPoolSettings connectionPoolSettings, LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            this.contactPoints = contactPoints;
            this.connectionPoolSettings = connectionPoolSettings;
            this.factory = new Factory(nioPoolSize);
            this.serializer = serializer;
            this.executor = Executors.newScheduledThreadPool(workerPoolSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("gremlin-driver-worker-%d").build());
        }

        synchronized void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.contactPoints.forEach(address -> {
                Host host = this.add((InetSocketAddress)address);
                if (host != null) {
                    host.makeAvailable();
                }
            });
        }

        public Host add(InetSocketAddress address) {
            Host newHost = new Host(address, Cluster.this);
            Host previous = this.hosts.putIfAbsent(address, newHost);
            return previous == null ? newHost : null;
        }

        Collection<Host> allHosts() {
            return this.hosts.values();
        }

        CompletableFuture<Void> close() {
            return CompletableFuture.supplyAsync(() -> {
                this.factory.shutdown();
                return null;
            }, Cluster.this.executor());
        }

        public String toString() {
            return String.join((CharSequence)", ", this.contactPoints.stream().map(InetSocketAddress::toString).collect(Collectors.toList()));
        }
    }

    static class Factory {
        private final EventLoopGroup group;

        public Factory(int nioPoolSize) {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-driver-loop-%d").build();
            this.group = new NioEventLoopGroup(nioPoolSize, (ThreadFactory)threadFactory);
        }

        Bootstrap createBootstrap() {
            Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
            b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            return b;
        }

        void shutdown() {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }

    public static class Builder {
        private List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 8182;
        private MessageSerializer serializer = Serializers.GRYO_V1D0.simpleInstance();
        private int nioPoolSize = Runtime.getRuntime().availableProcessors();
        private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        private int minConnectionPoolSize = 2;
        private int maxConnectionPoolSize = 8;
        private int minSimultaneousUsagePerConnection = 8;
        private int maxSimultaneousUsagePerConnection = 16;
        private int maxInProcessPerConnection = 4;
        private int minInProcessPerConnection = 1;
        private int maxWaitForConnection = 3000;
        private int maxContentLength = 65536;
        private int reconnectInitialDelay = 1000;
        private int reconnectInterval = 1000;
        private int resultIterationBatchSize = 64;
        private boolean enableSsl = false;
        private LoadBalancingStrategy loadBalancingStrategy = new LoadBalancingStrategy.RoundRobin();

        private Builder() {
        }

        private Builder(String address) {
            this.addContactPoint(address);
        }

        public Builder nioPoolSize(int nioPoolSize) {
            if (nioPoolSize < 1) {
                throw new IllegalArgumentException("The workerPoolSize must be greater than zero");
            }
            this.nioPoolSize = nioPoolSize;
            return this;
        }

        public Builder workerPoolSize(int workerPoolSize) {
            if (workerPoolSize < 1) {
                throw new IllegalArgumentException("The workerPoolSize must be greater than zero");
            }
            this.workerPoolSize = workerPoolSize;
            return this;
        }

        public Builder serializer(String mimeType) {
            this.serializer = Serializers.valueOf(mimeType).simpleInstance();
            return this;
        }

        public Builder serializer(Serializers mimeType) {
            this.serializer = mimeType.simpleInstance();
            return this;
        }

        public Builder serializer(MessageSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder enableSsl(boolean enable) {
            this.enableSsl = enable;
            return this;
        }

        public Builder minInProcessPerConnection(int minInProcessPerConnection) {
            this.minInProcessPerConnection = minInProcessPerConnection;
            return this;
        }

        public Builder maxInProcessPerConnection(int maxInProcessPerConnection) {
            this.maxInProcessPerConnection = maxInProcessPerConnection;
            return this;
        }

        public Builder maxSimultaneousUsagePerConnection(int maxSimultaneousUsagePerConnection) {
            this.maxSimultaneousUsagePerConnection = maxSimultaneousUsagePerConnection;
            return this;
        }

        public Builder minSimultaneousUsagePerConnection(int minSimultaneousUsagePerConnection) {
            this.minSimultaneousUsagePerConnection = minSimultaneousUsagePerConnection;
            return this;
        }

        public Builder maxConnectionPoolSize(int maxSize) {
            this.maxConnectionPoolSize = maxSize;
            return this;
        }

        public Builder minConnectionPoolSize(int minSize) {
            this.minConnectionPoolSize = minSize;
            return this;
        }

        public Builder resultIterationBatchSize(int size) {
            this.resultIterationBatchSize = size;
            return this;
        }

        public Builder maxWaitForConnection(int maxWait) {
            this.maxWaitForConnection = maxWait;
            return this;
        }

        public Builder maxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
            return this;
        }

        public Builder reconnectIntialDelay(int initialDelay) {
            this.reconnectInitialDelay = initialDelay;
            return this;
        }

        public Builder reconnectInterval(int interval) {
            this.reconnectInterval = interval;
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        private List<InetSocketAddress> getContactPoints() {
            return this.addresses.stream().map(addy -> new InetSocketAddress((InetAddress)addy, this.port)).collect(Collectors.toList());
        }

        public Cluster create() {
            if (this.addresses.size() == 0) {
                this.addContactPoint("localhost");
            }
            Settings.ConnectionPoolSettings connectionPoolSettings = new Settings.ConnectionPoolSettings();
            connectionPoolSettings.maxInProcessPerConnection = this.maxInProcessPerConnection;
            connectionPoolSettings.minInProcessPerConnection = this.minInProcessPerConnection;
            connectionPoolSettings.maxSimultaneousUsagePerConnection = this.maxSimultaneousUsagePerConnection;
            connectionPoolSettings.minSimultaneousUsagePerConnection = this.minSimultaneousUsagePerConnection;
            connectionPoolSettings.maxSize = this.maxConnectionPoolSize;
            connectionPoolSettings.minSize = this.minConnectionPoolSize;
            connectionPoolSettings.maxWaitForConnection = this.maxWaitForConnection;
            connectionPoolSettings.maxContentLength = this.maxContentLength;
            connectionPoolSettings.reconnectInitialDelay = this.reconnectInitialDelay;
            connectionPoolSettings.reconnectInterval = this.reconnectInterval;
            connectionPoolSettings.resultIterationBatchSize = this.resultIterationBatchSize;
            connectionPoolSettings.enableSsl = this.enableSsl;
            return new Cluster(this.getContactPoints(), this.serializer, this.nioPoolSize, this.workerPoolSize, connectionPoolSettings, this.loadBalancingStrategy);
        }
    }
}

