/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketClientHandler;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinRequestEncoder;
import org.apache.tinkerpop.gremlin.driver.handler.WebSocketGremlinResponseDecoder;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.simple.SimpleClient;

public class WebSocketClient
implements SimpleClient {
    private final Channel channel;
    private final EventLoopGroup group;
    private final CallbackResponseHandler callbackResponseHandler = new CallbackResponseHandler();

    public WebSocketClient() {
        this(URI.create("ws://localhost:8182"));
    }

    public WebSocketClient(URI uri) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("ws-client-%d").build();
        this.group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), (ThreadFactory)threadFactory);
        Bootstrap b = (Bootstrap)new Bootstrap().group(this.group);
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        try {
            final WebSocketClientHandler wsHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
            final GryoMessageSerializerV1d0 serializer = new GryoMessageSerializerV1d0();
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), wsHandler, new WebSocketGremlinRequestEncoder(true, serializer), new WebSocketGremlinResponseDecoder(serializer), WebSocketClient.this.callbackResponseHandler});
                }
            });
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            wsHandler.handshakeFuture().sync();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void submit(RequestMessage requestMessage, Consumer<ResponseMessage> callback) throws Exception {
        this.callbackResponseHandler.callback = callback;
        this.channel.writeAndFlush((Object)requestMessage).get();
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close().get();
        }
        catch (Exception exception) {
        }
        finally {
            this.group.shutdownGracefully().awaitUninterruptibly();
        }
    }

    static class CallbackResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        public Consumer<ResponseMessage> callback;

        CallbackResponseHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            try {
                this.callback.accept(response);
            }
            finally {
                ReferenceCountUtil.release((Object)response);
            }
        }
    }
}

