/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.JsonMessageSerializerGremlinV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.JsonMessageSerializerV1d0;

public enum Serializers {
    JSON("application/json"),
    JSON_V1D0("application/vnd.gremlin-v1.0+json"),
    GRYO_V1D0("application/vnd.gremlin-v1.0+gryo");

    private String value;
    public static final MessageSerializer DEFAULT_RESULT_SERIALIZER;
    public static final MessageSerializer DEFAULT_REQUEST_SERIALIZER;

    private Serializers(String mimeType) {
        this.value = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public MessageSerializer simpleInstance() {
        switch (this.value) {
            case "application/json": {
                return new JsonMessageSerializerV1d0();
            }
            case "application/vnd.gremlin-v1.0+json": {
                return new JsonMessageSerializerGremlinV1d0();
            }
            case "application/vnd.gremlin-v1.0+gryo": {
                return new GryoMessageSerializerV1d0();
            }
        }
        throw new RuntimeException("Could not create a simple MessageSerializer instance of " + this.value);
    }

    static {
        DEFAULT_RESULT_SERIALIZER = new JsonMessageSerializerV1d0();
        DEFAULT_REQUEST_SERIALIZER = new JsonMessageSerializerV1d0();
    }
}

