/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractJsonMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMessageSerializerV1d0
extends AbstractJsonMessageSerializerV1d0
implements MessageTextSerializer {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageSerializerV1d0.class);
    private static final String MIME_TYPE = "application/json";
    private static byte[] header;

    public JsonMessageSerializerV1d0() {
    }

    public JsonMessageSerializerV1d0(GraphSONMapper mapper) {
        super(mapper);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE};
    }

    @Override
    GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder builder) {
        return builder.addCustomModule((SimpleModule)new AbstractJsonMessageSerializerV1d0.GremlinServerModule()).embedTypes(false);
    }

    @Override
    byte[] obtainHeader() {
        return header;
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        try {
            Map responseData = (Map)this.mapper.readValue(msg, this.mapTypeReference);
            Map status = (Map)responseData.get("status");
            Map result = (Map)responseData.get("result");
            return ResponseMessage.build(UUID.fromString(responseData.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(status.get("message").toString()).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage) throws SerializationException {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", responseMessage.getResult().getData());
            result.put("meta", responseMessage.getResult().getMeta());
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("message", responseMessage.getStatus().getMessage());
            status.put("code", responseMessage.getStatus().getCode().getValue());
            status.put("attributes", responseMessage.getStatus().getAttributes());
            HashMap<String, Serializable> message = new HashMap<String, Serializable>();
            message.put("status", status);
            message.put("result", result);
            message.put("requestId", responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null);
            return this.mapper.writeValueAsString(message);
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new RuntimeException("Error during serialization.", ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        try {
            return (RequestMessage)this.mapper.readValue(msg, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)requestMessage);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)AbstractJsonMessageSerializerV1d0.class.getName());
            throw new RuntimeException("Error during serialization.", ex);
        }
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(MIME_TYPE.length() + 1);
        buffer.put((byte)MIME_TYPE.length());
        buffer.put(MIME_TYPE.getBytes());
        header = buffer.array();
    }
}

