/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public class RequestMessage {
    public static final RequestMessage INVALID = new RequestMessage("invalid");
    private final UUID requestId;
    private final String op;
    private final String processor;
    private final Map<String, Object> args;

    private RequestMessage(UUID requestId, String op, String processor, Map<String, Object> args) {
        this.requestId = requestId;
        this.op = op;
        this.processor = processor;
        this.args = Optional.ofNullable(args).orElse(new HashMap());
    }

    private RequestMessage() {
        this(null);
    }

    private RequestMessage(String op) {
        this(null, op, null, null);
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public String getOp() {
        return this.op;
    }

    public String getProcessor() {
        return this.processor;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public <T> Optional<T> optionalArgs(String key) {
        Object o = this.args.get(key);
        return o == null ? Optional.empty() : Optional.of(o);
    }

    public static Builder build(String op) {
        return new Builder(op);
    }

    public String toString() {
        return "RequestMessage{, requestId=" + this.requestId + ", op='" + this.op + '\'' + ", processor='" + this.processor + '\'' + ", args=" + this.args + '}';
    }

    public static final class Builder {
        public static final String OP_PROCESSOR_NAME = "";
        private UUID requestId = UUID.randomUUID();
        private String op;
        private String processor = "";
        private Map<String, Object> args = new HashMap<String, Object>();

        private Builder(String op) {
            this.op = op;
        }

        public Builder processor(String processor) {
            this.processor = processor;
            return this;
        }

        public Builder overrideRequestId(UUID requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder addArg(String key, Object val) {
            this.args.put(key, val);
            return this;
        }

        public Builder add(Object ... keyValues) {
            this.args.putAll(ElementHelper.asMap((Object[])keyValues));
            return this;
        }

        public RequestMessage create() {
            return new RequestMessage(this.requestId, this.op, this.processor, this.args);
        }
    }
}

