/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;

class ResponseQueue {
    private final LinkedBlockingQueue<ResponseMessage> responseQueue;
    private volatile Status status = Status.FETCHING;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final CompletableFuture<Void> readComplete;

    public ResponseQueue(LinkedBlockingQueue<ResponseMessage> responseQueue, CompletableFuture<Void> readComplete) {
        this.responseQueue = responseQueue;
        this.readComplete = readComplete;
    }

    public void add(ResponseMessage msg) {
        this.responseQueue.offer(msg);
    }

    public int size() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.responseQueue.size();
    }

    public boolean isEmpty() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.size() == 0;
    }

    public ResponseMessage poll() {
        ResponseMessage msg = null;
        do {
            if (this.error.get() != null) {
                throw new RuntimeException(this.error.get());
            }
            try {
                msg = this.responseQueue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                this.error.set(new RuntimeException(ie));
            }
        } while (null == msg && this.status == Status.FETCHING);
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return msg;
    }

    public Status getStatus() {
        return this.status;
    }

    void markComplete() {
        this.status = Status.COMPLETE;
        this.readComplete.complete(null);
    }

    void markError(Throwable throwable) {
        this.error.set(throwable);
        this.readComplete.complete(null);
    }

    public static enum Status {
        FETCHING,
        COMPLETE;

    }
}

