/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.console.groovy.plugin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.security.sasl.SaslException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteException;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.codehaus.groovy.tools.shell.Groovysh;

public class DriverRemoteAcceptor
implements RemoteAcceptor {
    private Cluster currentCluster;
    private Client.ClusteredClient currentClient;
    private int timeout = 180000;
    private Map<String, String> aliases = new HashMap<String, String>();
    private static final String TOKEN_RESET = "reset";
    private static final String TOKEN_SHOW = "show";
    private static final String TOKEN_MAX = "max";
    private static final String TOKEN_TIMEOUT = "timeout";
    private static final String TOKEN_ALIAS = "alias";
    private static final List<String> POSSIBLE_TOKENS = Arrays.asList("timeout", "alias");
    private final Groovysh shell;

    public DriverRemoteAcceptor(Groovysh shell) {
        this.shell = shell;
    }

    public Object connect(List<String> args) throws RemoteException {
        if (args.size() != 1) {
            throw new RemoteException("Expects the location of a configuration file as an argument");
        }
        try {
            this.currentCluster = Cluster.open((String)args.get(0));
            this.currentClient = (Client.ClusteredClient)this.currentCluster.connect();
            this.currentClient.init();
            return String.format("Connected - " + this.currentCluster, new Object[0]);
        }
        catch (FileNotFoundException ignored) {
            throw new RemoteException("The 'connect' option must be accompanied by a valid configuration file");
        }
        catch (Exception ex) {
            throw new RemoteException("Error during 'connect' - " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object configure(List<String> args) throws RemoteException {
        String option;
        String string = option = args.size() == 0 ? "" : args.get(0);
        if (!POSSIBLE_TOKENS.contains(option)) {
            throw new RemoteException(String.format("The 'config' option expects one of ['%s'] as an argument", String.join((CharSequence)",", POSSIBLE_TOKENS)));
        }
        List<String> arguments = args.subList(1, args.size());
        if (option.equals(TOKEN_TIMEOUT)) {
            String errorMessage = "The timeout option expects a positive integer representing milliseconds or 'max' as an argument";
            if (arguments.size() != 1) {
                throw new RemoteException("The timeout option expects a positive integer representing milliseconds or 'max' as an argument");
            }
            try {
                int to;
                int n = to = arguments.get(0).equals(TOKEN_MAX) ? Integer.MAX_VALUE : Integer.parseInt(arguments.get(0));
                if (to <= 0) {
                    throw new RemoteException("The timeout option expects a positive integer representing milliseconds or 'max' as an argument");
                }
                this.timeout = to;
                return "Set remote timeout to " + to + "ms";
            }
            catch (Exception ignored) {
                throw new RemoteException("The timeout option expects a positive integer representing milliseconds or 'max' as an argument");
            }
        }
        if (option.equals(TOKEN_ALIAS)) {
            if (arguments.size() == 1 && arguments.get(0).equals(TOKEN_RESET)) {
                this.aliases.clear();
                return "Aliases cleared";
            }
            if (arguments.size() == 1 && arguments.get(0).equals(TOKEN_SHOW)) {
                return this.aliases;
            }
            if (arguments.size() % 2 != 0) {
                throw new RemoteException("Arguments to alias must be 'reset' to clear any existing alias settings or key/value alias/binding pairs");
            }
            Map aliasMap = ElementHelper.asMap((Object[])arguments.toArray());
            this.aliases.clear();
            aliasMap.forEach((k, v) -> this.aliases.put((String)k, v.toString()));
            return this.aliases;
        }
        return this.toString();
    }

    public Object submit(List<String> args) throws RemoteException {
        String line = RemoteAcceptor.getScript((String)String.join((CharSequence)" ", args), (Groovysh)this.shell);
        try {
            List<Result> resultSet = this.send(line);
            this.shell.getInterp().getContext().setProperty("result", resultSet);
            return resultSet.stream().map(result -> result.getObject()).iterator();
        }
        catch (SaslException sasl) {
            throw new RemoteException("Security error - check username/password and related settings", (Throwable)sasl);
        }
        catch (Exception ex) {
            Optional<ResponseException> inner = this.findResponseException(ex);
            if (inner.isPresent()) {
                ResponseException responseException = inner.get();
                if (responseException.getResponseStatusCode() == ResponseStatusCode.SERVER_ERROR_SERIALIZATION) {
                    throw new RemoteException(String.format("Server could not serialize the result requested. Server error - %s. Note that the class must be serializable by the client and server for proper operation.", responseException.getMessage()));
                }
                throw new RemoteException(responseException.getMessage());
            }
            if (ex.getCause() != null) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
                if (rootCause instanceof TimeoutException) {
                    throw new RemoteException("Host did not respond in a timely fashion - check the server status and submit again.");
                }
                throw new RemoteException(rootCause.getMessage());
            }
            throw new RemoteException(ex.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.currentClient != null) {
            this.currentClient.close();
        }
        if (this.currentCluster != null) {
            this.currentCluster.close();
        }
    }

    private List<Result> send(String gremlin) throws SaslException {
        try {
            return (List)((ResultSet)this.currentClient.submitAsync(gremlin, this.aliases, Collections.emptyMap()).get()).all().get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ignored) {
            throw new IllegalStateException("Request timed out while processing - increase the timeout with the :remote command");
        }
        catch (Exception e) {
            Optional<Throwable> throwable = Stream.of(ExceptionUtils.getThrowables((Throwable)e)).filter(t -> t instanceof SaslException).findFirst();
            if (throwable.isPresent()) {
                throw (SaslException)throwable.get();
            }
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String toString() {
        return "Gremlin Server - [" + this.currentCluster + "]";
    }

    private Optional<ResponseException> findResponseException(Throwable ex) {
        if (ex instanceof ResponseException) {
            return Optional.of((ResponseException)ex);
        }
        if (null == ex.getCause()) {
            return Optional.empty();
        }
        return this.findResponseException(ex.getCause());
    }
}

