/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.mustache;

import com.sampullara.mustache.MustacheBuilder;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.Scope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;

public final class MustacheRenderer
implements Renderer {
    private Pattern acceptPattern;

    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        try {
            new MustacheBuilder().build((Reader)new BufferedReader(new InputStreamReader(MustacheRenderer.getResourceStream(request, path))), path).execute(request.getWriter(), MustacheRenderer.buildScope(request));
        }
        catch (MustacheException ex) {
            throw new IOException("failed to MustacheRenderer.render(" + path + ",request)", ex);
        }
    }

    private static InputStream getResourceStream(Request request, String path) throws IOException {
        ApplicationContext applicationContext = request.getApplicationContext();
        ApplicationResource resource = applicationContext.getResource(path);
        return resource.getInputStream();
    }

    private static Scope buildScope(Request request) {
        Scope scope = null;
        List availableScopes = request.getAvailableScopes();
        for (int i = availableScopes.size() - 1; i >= 0; --i) {
            scope = null == scope ? new Scope((Object)request.getContext((String)availableScopes.get(i))) : new Scope((Object)request.getContext((String)availableScopes.get(i)), scope);
        }
        return scope;
    }

    public boolean isRenderable(String path, Request request) {
        if (path == null) {
            return false;
        }
        if (this.acceptPattern != null) {
            Matcher matcher = this.acceptPattern.matcher(path);
            return matcher.matches();
        }
        return true;
    }

    public void setAcceptPattern(Pattern acceptPattern) {
        this.acceptPattern = acceptPattern;
    }
}

