/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesException;
import org.apache.tiles.jsp.taglib.AttributeTagSupport;
import org.apache.tiles.jsp.taglib.TilesJspException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAttributeTag
extends AttributeTagSupport {
    private final Log log = LogFactory.getLog(ImportAttributeTag.class);
    private String toName;

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    @Override
    protected void reset() {
        super.reset();
        this.toName = null;
    }

    @Override
    public void execute() throws TilesJspException {
        if (this.attributeValue != null) {
            this.pageContext.setAttribute(this.toName != null ? this.toName : this.name, this.attributeValue, this.scope);
        } else {
            this.importAttributes(this.attributeContext.getCascadedAttributeNames());
            this.importAttributes(this.attributeContext.getLocalAttributeNames());
        }
    }

    private void importAttributes(Collection<String> names) throws TilesJspException {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String name : names) {
            if (name == null && !this.ignore) {
                throw new TilesJspException("Error importing attributes. Attribute with null key found.");
            }
            if (name == null) continue;
            Attribute attr = this.attributeContext.getAttribute(name);
            if (attr != null) {
                try {
                    Object attributeValue = this.container.evaluate(attr, new Object[]{this.pageContext});
                    if (attributeValue == null) {
                        if (this.ignore) continue;
                        throw new TilesJspException("Error importing attributes. Attribute '" + name + "' has a null value ");
                    }
                    this.pageContext.setAttribute(name, attributeValue, this.scope);
                }
                catch (TilesException e) {
                    if (!this.ignore) {
                        throw e;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"Ignoring Tiles Exception", (Throwable)e);
                }
                continue;
            }
            if (this.ignore) continue;
            throw new TilesJspException("Error importing attributes. Attribute '" + name + "' is null");
        }
    }
}

