/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.context;

import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.impl.NoSuchContainerException;
import org.apache.tiles.servlet.context.ServletUtil;

public final class JspUtil {
    private JspUtil() {
    }

    public static boolean isForceInclude(PageContext context) {
        Boolean retValue = (Boolean)context.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", 2);
        return retValue != null && retValue != false;
    }

    public static void setForceInclude(PageContext context, boolean forceInclude) {
        Boolean retValue = forceInclude;
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", (Object)retValue, 2);
    }

    public static TilesContainer getContainer(PageContext context) {
        return JspUtil.getContainer(context, "org.apache.tiles.CONTAINER");
    }

    public static TilesContainer getContainer(PageContext context, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)context.getAttribute(key, 4);
    }

    public static void setContainer(PageContext context, TilesContainer container) {
        JspUtil.setContainer(context, container, "org.apache.tiles.CONTAINER");
    }

    public static void setContainer(PageContext context, TilesContainer container, String key) {
        Log log = LogFactory.getLog(ServletUtil.class);
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        if (container == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing TilesContext for context: " + context.getClass().getName()));
            }
            context.removeAttribute(key, 4);
        }
        if (container != null && log.isInfoEnabled()) {
            log.info((Object)("Publishing TilesContext for context: " + context.getClass().getName()));
        }
        context.setAttribute(key, (Object)container, 4);
    }

    public static void setCurrentContainer(PageContext context, String key) {
        TilesContainer container = JspUtil.getContainer(context, key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
    }

    public static void setCurrentContainer(PageContext context, TilesContainer container) {
        if (container == null) {
            throw new NoSuchContainerException("The container cannot be null");
        }
        context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
    }

    public static TilesContainer getCurrentContainer(PageContext context) {
        TilesContainer container = (TilesContainer)context.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", 2);
        if (container == null) {
            container = JspUtil.getContainer(context);
            context.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container, 2);
        }
        return container;
    }
}

