/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.jsp.taglib.NoSuchAttributeException;
import org.apache.tiles.jsp.taglib.RenderTag;
import org.apache.tiles.jsp.taglib.TilesJspException;

public class InsertAttributeTag
extends RenderTag {
    protected String name;
    protected Object value = null;
    protected Object defaultValue;
    protected String defaultValueType;
    protected String defaultValueRole;
    protected Attribute attribute;

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueType() {
        return this.defaultValueType;
    }

    public void setDefaultValueType(String defaultValueType) {
        this.defaultValueType = defaultValueType;
    }

    public String getDefaultValueRole() {
        return this.defaultValueRole;
    }

    public void setDefaultValueRole(String defaultValueRole) {
        this.defaultValueRole = defaultValueRole;
    }

    protected void reset() {
        super.reset();
        this.name = null;
        this.value = null;
        this.defaultValue = null;
        this.defaultValueType = null;
        this.defaultValueType = null;
        this.attribute = null;
    }

    public int doStartTag() throws TilesJspException {
        if (this.value == null && this.name == null) {
            throw new TilesJspException("No attribute name or value has been provided.");
        }
        return super.doStartTag();
    }

    protected void render() throws TilesJspException, IOException {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (this.role != null && !req.isUserInRole(this.role) || this.attribute == null && this.ignore) {
            return;
        }
        this.render(this.attribute);
    }

    protected void startContext(PageContext context) {
        if (this.preparer != null) {
            this.container.prepare(this.preparer, new Object[]{context});
        }
        this.attribute = this.computeAttribute(context);
        super.startContext(context);
    }

    protected void render(Attribute attr) throws IOException {
        this.container.render(attr, new Object[]{this.pageContext});
    }

    private Attribute computeAttribute(PageContext context) {
        AttributeContext evaluatingContext;
        Attribute attribute = (Attribute)this.value;
        if (attribute == null && (attribute = (evaluatingContext = this.container.getAttributeContext(new Object[]{context})).getAttribute(this.name)) == null && (attribute = this.computeDefaultAttribute()) == null && !this.ignore) {
            throw new NoSuchAttributeException("Attribute '" + this.name + "' not found.");
        }
        return attribute;
    }

    private Attribute computeDefaultAttribute() {
        Attribute attribute = null;
        if (this.defaultValue != null) {
            if (this.defaultValue instanceof Attribute) {
                attribute = (Attribute)this.defaultValue;
            } else if (this.defaultValue instanceof String) {
                attribute = new Attribute(this.defaultValue, null, this.defaultValueRole, this.defaultValueType);
            }
        }
        return attribute;
    }
}

