/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib.definition;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.jsp.taglib.PutAttributeTag;
import org.apache.tiles.jsp.taglib.PutAttributeTagParent;
import org.apache.tiles.jsp.taglib.TilesTag;
import org.apache.tiles.mgmt.MutableTilesContainer;

public class DefinitionTag
extends TilesTag
implements PutAttributeTagParent {
    private String name;
    private String template;
    private String extend;
    private String role;
    private String preparer;
    private MutableTilesContainer container;
    private Map<String, Attribute> attributes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getExtends() {
        return this.extend;
    }

    public void setExtends(String extend) {
        this.extend = extend;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getPreparer() {
        return this.preparer;
    }

    public void setPreparer(String preparer) {
        this.preparer = preparer;
    }

    protected void reset() {
        super.reset();
        this.name = null;
        this.template = null;
        this.extend = null;
        this.role = null;
        this.preparer = null;
        this.attributes.clear();
    }

    public int doStartTag() throws JspException {
        this.attributes = new HashMap<String, Attribute>();
        TilesContainer c = TilesAccess.getContainer((Object)this.pageContext.getServletContext());
        if (c == null) {
            throw new JspException("TilesContainer not initialized");
        }
        if (!(c instanceof MutableTilesContainer)) {
            throw new JspException("Unable to define definition for a container which does not implement MutableTilesContainer");
        }
        this.container = (MutableTilesContainer)c;
        return 1;
    }

    public int doEndTag() throws JspException {
        Definition d = new Definition();
        d.setName(this.name);
        d.setTemplate(this.template);
        d.setExtends(this.extend);
        d.setRole(this.role);
        d.setPreparer(this.preparer);
        d.getAttributes().putAll(this.attributes);
        try {
            this.container.register(d, new Object[]{this.pageContext});
        }
        catch (TilesException e) {
            throw new JspException("Unable to add definition. ", (Throwable)e);
        }
        return 6;
    }

    public void processNestedTag(PutAttributeTag nestedTag) throws JspException {
        Attribute attr = new Attribute(nestedTag.getValue(), nestedTag.getRole(), Attribute.AttributeType.getType((String)nestedTag.getType()));
        this.attributes.put(nestedTag.getName(), attr);
    }
}

