/*
 * $Id: DestroyContainerTag.java 727715 2008-12-18 13:06:06Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.jsp.taglib.definition;

import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.jsp.taglib.TilesTag;

import javax.servlet.jsp.JspException;

/**
 * Destroys the accessible container.
 *
 * @version $Rev: 727715 $ $Date: 2008-12-18 14:06:06 +0100 (Thu, 18 Dec 2008) $
 */
public class DestroyContainerTag extends TilesTag {

    /** {@inheritDoc} */
    @Override
    public int doEndTag() throws JspException {
        try {
            TilesAccess.setContainer(pageContext.getServletContext(), null);
        } catch (TilesException e) {
            throw new JspException(e);
        }
        return EVAL_PAGE;
    }
}
