/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesException;

public abstract class RoleSecurityTagSupport
extends BodyTagSupport {
    private static final Log LOG = LogFactory.getLog(RoleSecurityTagSupport.class);
    private String role;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.isAccessAllowed()) {
                this.execute();
            }
        }
        catch (TilesException e) {
            String message = "Error executing tag: " + e.getMessage();
            LOG.error((Object)message, (Throwable)e);
            throw new JspException(message, (Throwable)e);
        }
        catch (IOException io) {
            String message = "IO Error executing tag: " + io.getMessage();
            LOG.error((Object)message, (Throwable)io);
            throw new JspException(message, (Throwable)io);
        }
        return 6;
    }

    public void release() {
        super.release();
        this.role = null;
    }

    protected abstract void execute() throws TilesException, JspException, IOException;

    protected boolean isAccessAllowed() {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        return this.role == null || req.isUserInRole(this.role);
    }
}

