/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.jsp.taglib;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;

public abstract class AttributeTagSupport
extends TagSupport {
    private static final Map<String, Integer> scopes = new HashMap<String, Integer>();
    protected String scopeName = null;
    protected int scope = 1;
    protected String name = null;
    protected boolean ignore = false;
    protected TilesContainer container;
    protected AttributeContext attributeContext;
    protected Attribute attribute;

    public void setScope(String scope) {
        this.scopeName = scope;
    }

    public String getScope() {
        return this.scopeName;
    }

    public void release() {
        this.scopeName = null;
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        this.container = TilesAccess.getContainer((Object)this.pageContext.getServletContext());
        this.attributeContext = this.container.getAttributeContext(new Object[]{this.pageContext});
        this.scope = this.getScopeId();
        if (this.name != null) {
            this.attribute = this.attributeContext.getAttribute(this.name);
            if ((this.attribute == null || this.attribute.getValue() == null) && this.ignore) {
                return 0;
            }
            if (this.attribute == null) {
                throw new JspException("Attribute whith name '" + this.name + "' not found");
            }
            if (this.attribute.getValue() == null) {
                throw new JspException("Attribute whith name '" + this.name + "' has a null value.");
            }
        }
        try {
            this.execute();
        }
        catch (IOException e) {
            throw new JspException("io error while executing tag '" + ((Object)((Object)this)).getClass().getName() + "'.", (Throwable)e);
        }
        return 0;
    }

    public abstract void execute() throws JspException, IOException;

    public int doEndTag() {
        return 6;
    }

    public int getScopeId() throws JspException {
        if (this.scopeName == null) {
            return 1;
        }
        return AttributeTagSupport.getScope(this.scopeName);
    }

    public static int getScope(String scopeName) throws JspException {
        Integer scope = scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException("Unable to retrieve the scope " + scopeName);
        }
        return scope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    static {
        scopes.put("page", 1);
        scopes.put("request", 2);
        scopes.put("session", 3);
        scopes.put("application", 4);
    }
}

