/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.Attribute;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptionsRenderer
implements Renderer {
    public static final String CACHE_LIFE_PROPERTY = OptionsRenderer.class.getName() + ".cache_ttl_ms";
    public static final long DEFAULT_CACHE_LIFE = 300000L;
    public static final Pattern OPTIONS_PATTERN = Pattern.compile(Pattern.quote("{options[") + "(.+)" + Pattern.quote("]}"));
    private static final Logger LOG = LoggerFactory.getLogger(OptionsRenderer.class);
    private final ApplicationContext applicationContext;
    private final Renderer renderer;

    public OptionsRenderer(ApplicationContext applicationContext, Renderer renderer) {
        this.applicationContext = applicationContext;
        this.renderer = renderer;
    }

    public boolean isRenderable(String path, Request request) {
        return this.renderer.isRenderable(path, request);
    }

    public void render(String path, Request request) throws IOException {
        Matcher matcher = OPTIONS_PATTERN.matcher(path);
        if (null != matcher && matcher.find()) {
            boolean done = false;
            String match = matcher.group(1);
            ListAttribute fallbacks = (ListAttribute)TilesAccess.getCurrentContainer((Request)request).getAttributeContext(request).getAttribute(match);
            if (null == fallbacks) {
                throw new IllegalStateException("A matching list-attribute name=\"" + match + "\" must be defined.");
            }
            if (fallbacks.getValue().isEmpty()) {
                throw new IllegalStateException("list-attribute name=\"" + match + "\" must have minimum one attribute");
            }
            for (Attribute option : fallbacks.getValue()) {
                String template = path.replaceFirst(Pattern.quote(matcher.group()), (String)option.getValue());
                done = this.renderAttempt(template, request);
                if (!done) continue;
                break;
            }
            if (!done) {
                throw new IOException("None of the options existed for " + path);
            }
        } else {
            this.renderer.render(path, request);
        }
    }

    private boolean renderAttempt(String template, Request request) throws IOException {
        boolean result = false;
        if (Cache.attemptTemplate(template)) {
            try {
                if (null != this.applicationContext.getResource(template)) {
                    this.renderer.render(template, request);
                    result = true;
                }
            }
            catch (IOException ex) {
                if (ex.getMessage().contains(template)) {
                    LOG.trace(ex.getMessage());
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (ex.getMessage().contains(template)) {
                    LOG.trace(ex.getMessage());
                }
                throw ex;
            }
            Cache.update(template, result);
        }
        return result;
    }

    private static final class Cache {
        private static final long CACHE_LIFE = Long.getLong(CACHE_LIFE_PROPERTY, 300000L);
        private static final ConcurrentMap<String, Boolean> TEMPLATE_EXISTS;

        static boolean attemptTemplate(String template) {
            return !TEMPLATE_EXISTS.containsKey(template) || (Boolean)TEMPLATE_EXISTS.get(template) != false;
        }

        static void update(String template, boolean found) {
            TEMPLATE_EXISTS.putIfAbsent(template, found);
        }

        private Cache() {
        }

        static {
            LOG.info("cache_ttl_ms=" + CACHE_LIFE);
            LoadingCache builder = CacheBuilder.newBuilder().expireAfterWrite(CACHE_LIFE, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, Boolean>(){

                public Boolean load(String key) {
                    throw new UnsupportedOperationException("illegal TEMPLATE_EXISTS.get(\"" + key + "\") before TEMPLATE_EXISTS.containsKey(\"" + key + "\")");
                }
            });
            TEMPLATE_EXISTS = builder.asMap();
        }
    }
}

