/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.serialization.TikaJsonSerializer;
import org.apache.tika.serialization.TikaSerializationException;

public class ParseContextSerializer
extends JsonSerializer<ParseContext> {
    public static final String PARSE_CONTEXT = "parseContext";

    @Override
    public void serialize(ParseContext parseContext, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeFieldName(PARSE_CONTEXT);
        jsonGenerator.writeStartObject();
        for (String className : parseContext.keySet()) {
            try {
                Class<?> clazz = Class.forName(className);
                TikaJsonSerializer.serialize(className, parseContext.get(clazz), jsonGenerator);
            }
            catch (TikaSerializationException e) {
                throw new IOException((Throwable)((Object)e));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        jsonGenerator.writeEndObject();
    }
}

