/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.config.ConfigBase;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;

public class TikaServerClientConfig
extends ConfigBase
implements Initializable {
    private HttpClientFactory httpClientFactory;
    private int numThreads = 1;
    private MODE mode = MODE.PIPES;
    private List<String> tikaEndpoints = new ArrayList<String>();
    private long maxWaitMillis = 60000L;

    public static TikaServerClientConfig build(Path configFile) throws IOException, TikaConfigException {
        try (InputStream is = Files.newInputStream(configFile, new OpenOption[0]);){
            TikaServerClientConfig tikaServerClientConfig = TikaServerClientConfig.buildSingle("serverClientConfig", TikaServerClientConfig.class, is);
            return tikaServerClientConfig;
        }
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMs) {
        this.maxWaitMillis = maxWaitMs;
    }

    public void setMode(String mode) {
        if ("pipes".equals(mode)) {
            this.mode = MODE.PIPES;
            return;
        }
        throw new IllegalArgumentException("I regret that we have not yet implemented: '" + mode + "'");
    }

    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public MODE getMode() {
        return this.mode;
    }

    public List<String> getTikaEndpoints() {
        return this.tikaEndpoints;
    }

    public void setTikaEndpoints(List<String> tikaEndpoints) {
        this.tikaEndpoints = tikaEndpoints;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (this.tikaEndpoints.size() == 0) {
            throw new TikaConfigException("tikaEndpoints must not be empty");
        }
    }

    static enum MODE {
        PIPES,
        ASYNC;

    }
}

