/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.tika.metadata.Metadata;

public class JsonMetadataDeserializer
implements JsonDeserializer<Metadata> {
    public Metadata deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = element.getAsJsonObject();
        Metadata m = new Metadata();
        for (Map.Entry entry : obj.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement v = (JsonElement)entry.getValue();
            if (v.isJsonPrimitive()) {
                m.set(key, v.getAsString());
                continue;
            }
            if (!v.isJsonArray()) continue;
            JsonArray vArr = v.getAsJsonArray();
            for (JsonElement valueItem : vArr) {
                m.add(key, valueItem.getAsString());
            }
        }
        return m;
    }
}

