/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.ClientHTTP2StreamEndPoint;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP2.class);
    private final ContentNotifier contentNotifier = new ContentNotifier(this);

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void receive() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        this.contentNotifier.receive(this.getHttpChannel().getStream(), exchange);
    }

    @Override
    protected void reset() {
        super.reset();
        this.contentNotifier.reset();
    }

    void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)frame.getMetaData();
            httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
            if (this.responseBegin(exchange)) {
                HttpFields headers = response.getFields();
                for (HttpField header : headers) {
                    if (this.responseHeader(exchange, header)) continue;
                    return;
                }
                HttpRequest httpRequest = exchange.getRequest();
                if (MetaData.isTunnel(httpRequest.getMethod(), httpResponse.getStatus())) {
                    ClientHTTP2StreamEndPoint endPoint = new ClientHTTP2StreamEndPoint((IStream)stream);
                    long idleTimeout = httpRequest.getIdleTimeout();
                    if (idleTimeout > 0L) {
                        endPoint.setIdleTimeout(idleTimeout);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successful HTTP2 tunnel on {} via {}", (Object)stream, (Object)endPoint);
                    }
                    ((IStream)stream).setAttachment(endPoint);
                    HttpConversation conversation = httpRequest.getConversation();
                    conversation.setAttribute(EndPoint.class.getName(), endPoint);
                    HttpUpgrader upgrader = (HttpUpgrader)conversation.getAttribute(HttpUpgrader.class.getName());
                    if (upgrader != null) {
                        this.upgrade(upgrader, httpResponse, endPoint);
                    }
                }
                this.contentNotifier.notifySuccess = frame.isEndStream();
                if (this.responseHeaders(exchange)) {
                    int status = response.getStatus();
                    if (frame.isEndStream() || HttpStatus.isInterim(status)) {
                        this.responseSuccess(exchange);
                    } else {
                        stream.demand(1L);
                    }
                }
            }
        } else {
            HttpFields trailers = metaData.getFields();
            trailers.forEach(httpResponse::trailer);
            if (((IStream)stream).dataSize() == 0) {
                this.responseSuccess(exchange);
            } else {
                this.contentNotifier.notifySuccess = true;
            }
        }
    }

    private void upgrade(HttpUpgrader upgrader, HttpResponse response, EndPoint endPoint) {
        try {
            upgrader.upgrade(response, endPoint, Callback.from(Callback.NOOP::succeeded, x$0 -> this.responseFailure((Throwable)x$0)));
        }
        catch (Throwable x) {
            this.responseFailure(x);
        }
    }

    Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        HttpRequest request = exchange.getRequest();
        MetaData.Request metaData = frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getURIString());
        BiFunction<Request, Request, Response.CompleteListener> pushListener = request.getPushListener();
        if (pushListener != null && (listener = pushListener.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().newHttpChannel();
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest, List.of(listener));
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    @Override
    public void onData(DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed(new IOException("terminated"));
        } else {
            this.notifyContent(exchange, frame, callback);
        }
    }

    void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        int error = frame.getError();
        exchange.getRequest().abort(new IOException(ErrorCode.toString(error, "reset_code_" + error)));
    }

    @Override
    public boolean onTimeout(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        return !exchange.abort(failure);
    }

    @Override
    public void onFailure(Throwable failure, Callback callback) {
        this.responseFailure(failure);
        callback.succeeded();
    }

    private void notifyContent(HttpExchange exchange, DataFrame frame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received content {}", (Object)frame);
        }
        this.contentNotifier.process(this.getHttpChannel().getStream(), exchange, frame, callback);
    }

    private static class ContentNotifier {
        private final HttpReceiverOverHTTP2 receiver;
        private volatile boolean notifySuccess;

        private ContentNotifier(HttpReceiverOverHTTP2 receiver) {
            this.receiver = receiver;
        }

        public void receive(Stream stream, HttpExchange exchange) {
            if (this.notifySuccess && ((IStream)stream).dataSize() == 0) {
                this.receiver.responseSuccess(exchange);
            } else {
                stream.demand(1L);
            }
        }

        private void process(Stream stream, HttpExchange exchange, DataFrame dataFrame, Callback callback) {
            if (dataFrame.getData().hasRemaining()) {
                boolean proceed;
                if (dataFrame.isEndStream()) {
                    this.notifySuccess = true;
                }
                if (proceed = this.receiver.responseContent(exchange, dataFrame.getData(), Callback.from(callback::succeeded, x -> this.fail(callback, (Throwable)x)))) {
                    if (dataFrame.isEndStream()) {
                        this.receiver.responseSuccess(exchange);
                    } else {
                        stream.demand(1L);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Stalling processing, no demand after {} on {}", (Object)dataFrame, (Object)this);
                }
            } else {
                callback.succeeded();
                if (dataFrame.isEndStream()) {
                    this.receiver.responseSuccess(exchange);
                } else {
                    stream.demand(1L);
                }
            }
        }

        private void reset() {
            this.notifySuccess = false;
        }

        private void fail(Callback callback, Throwable failure) {
            callback.failed(failure);
            this.receiver.responseFailure(failure);
        }
    }
}

