/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HistogramEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public HistogramEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object doWork(Object ... values) throws IOException {
        List<Object> sourceValues;
        if (Arrays.stream(values).anyMatch(item -> null == item)) {
            return null;
        }
        Integer bins = 10;
        if (values.length < 1) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        List<Object> list = sourceValues = values[0] instanceof List ? (List<Object>)values[0] : Arrays.asList(values[0]);
        if (values.length >= 2) {
            if (!(values[1] instanceof Number)) throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - if second parameter is provided then it must be a valid number but found %s instead", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
            bins = ((Number)values[1]).intValue();
        }
        EmpiricalDistribution distribution = new EmpiricalDistribution(bins);
        distribution.load(sourceValues.stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        ArrayList<Tuple> histogramBins = new ArrayList<Tuple>();
        for (SummaryStatistics binSummary : distribution.getBinStats()) {
            Tuple tuple = new Tuple();
            tuple.put("max", binSummary.getMax());
            tuple.put("mean", binSummary.getMean());
            tuple.put("min", binSummary.getMin());
            tuple.put("stdev", binSummary.getStandardDeviation());
            tuple.put("sum", binSummary.getSum());
            tuple.put("N", binSummary.getN());
            tuple.put("var", binSummary.getVariance());
            tuple.put("cumProb", distribution.cumulativeProbability(binSummary.getMean()));
            tuple.put("prob", distribution.probability(binSummary.getMin(), binSummary.getMax()));
            histogramBins.add(tuple);
        }
        return histogramBins;
    }
}

