/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHTTP2StreamEndPoint.class);

    public ClientHTTP2StreamEndPoint(IStream stream) {
        super(stream);
    }

    @Override
    public void onData(DataFrame frame, Callback callback) {
        this.offerData(frame, callback);
    }

    @Override
    public boolean onTimeout(Throwable failure) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}: {}", (Object)this, (Object)failure);
        }
        if ((connection = this.getConnection()) != null) {
            return connection.onIdleExpired();
        }
        return true;
    }

    @Override
    public void onFailure(Throwable failure, Callback callback) {
        callback.failed(failure);
    }
}

