/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.solr;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrPipesIterator.class);
    private final HttpClientFactory httpClientFactory;
    private String solrCollection;
    private List<String> solrUrls = Collections.emptyList();
    private List<String> solrZkHosts = Collections.emptyList();
    private String solrZkChroot;
    private List<String> filters = Collections.emptyList();
    private String idField;
    private String parsingIdField;
    private String failCountField;
    private String sizeFieldName;
    private List<String> additionalFields = Collections.emptyList();
    private int rows = 5000;
    private int connectionTimeout = 10000;
    private int socketTimeout = 60000;

    public SolrPipesIterator() throws TikaConfigException {
        this.httpClientFactory = new HttpClientFactory();
    }

    @Field
    public void setSolrZkHosts(List<String> solrZkHosts) {
        this.solrZkHosts = solrZkHosts;
    }

    @Field
    public void setSolrZkChroot(String solrZkChroot) {
        this.solrZkChroot = solrZkChroot;
    }

    @Field
    public void setSolrCollection(String solrCollection) {
        this.solrCollection = solrCollection;
    }

    @Field
    public void setSolrUrls(List<String> solrUrls) {
        this.solrUrls = solrUrls;
    }

    @Field
    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    @Field
    public void setAdditionalFields(List<String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Field
    public void setIdField(String idField) {
        this.idField = idField;
    }

    @Field
    public void setParsingIdField(String parsingIdField) {
        this.parsingIdField = parsingIdField;
    }

    @Field
    public void setFailCountField(String failCountField) {
        this.failCountField = failCountField;
    }

    @Field
    public void setSizeFieldName(String sizeFieldName) {
        this.sizeFieldName = sizeFieldName;
    }

    @Field
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Field
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Field
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Field
    public void setUserName(String userName) {
        this.httpClientFactory.setUserName(userName);
    }

    @Field
    public void setPassword(String password) {
        this.httpClientFactory.setPassword(password);
    }

    @Field
    public void setAuthScheme(String authScheme) {
        this.httpClientFactory.setAuthScheme(authScheme);
    }

    @Field
    public void setProxyHost(String proxyHost) {
        this.httpClientFactory.setProxyHost(proxyHost);
    }

    @Field
    public void setProxyPort(int proxyPort) {
        this.httpClientFactory.setProxyPort(proxyPort);
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        try (SolrClient solrClient = this.createSolrClient();){
            int fileCount = 0;
            SolrQuery query = new SolrQuery();
            query.set("q", "*:*");
            query.setRows(this.rows);
            HashSet<String> allFields = new HashSet<String>();
            allFields.add("id");
            allFields.add(this.idField);
            allFields.add(this.parsingIdField);
            allFields.add(this.failCountField);
            allFields.add(this.sizeFieldName);
            allFields.addAll(this.additionalFields);
            query.setFields(allFields.toArray(new String[0]));
            query.setSort(SolrQuery.SortClause.asc(this.parsingIdField));
            query.addSort(SolrQuery.SortClause.asc("id"));
            query.setFilterQueries(this.filters.toArray(new String[0]));
            HandlerConfig handlerConfig = this.getHandlerConfig();
            String cursorMark = "*";
            boolean done = false;
            while (!done) {
                query.set("cursorMark", cursorMark);
                QueryResponse qr = solrClient.query(this.solrCollection, query);
                long totalToFetch = qr.getResults().getNumFound();
                String nextCursorMark = qr.getNextCursorMark();
                LOGGER.info("Query to fetch files to parse collection={}, q={}, onCount={}, totalCount={}", this.solrCollection, query, fileCount, totalToFetch);
                for (SolrDocument sd : qr.getResults()) {
                    ++fileCount;
                    String fetchKey = (String)sd.getFieldValue(this.idField);
                    String emitKey = (String)sd.getFieldValue(this.idField);
                    Metadata metadata = new Metadata();
                    for (String nextField : allFields) {
                        metadata.add(nextField, (String)sd.getFieldValue(nextField));
                    }
                    LOGGER.info("iterator doc: {}, idField={}, fetchKey={}", sd, this.idField, fetchKey);
                    ParseContext parseContext = new ParseContext();
                    parseContext.set(HandlerConfig.class, (Object)handlerConfig);
                    this.tryToAdd(new FetchEmitTuple(fetchKey, new FetchKey(fetcherName, fetchKey), new EmitKey(emitterName, emitKey), new Metadata(), parseContext, this.getOnParseException()));
                }
                if (cursorMark.equals(nextCursorMark)) {
                    done = true;
                }
                cursorMark = nextCursorMark;
            }
        }
        catch (SolrServerException | TikaConfigException e) {
            LOGGER.error("Could not iterate through solr", e);
        }
    }

    private SolrClient createSolrClient() throws TikaConfigException {
        if (this.solrUrls == null || this.solrUrls.isEmpty()) {
            return ((CloudSolrClient.Builder)((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(this.solrZkHosts, Optional.ofNullable(this.solrZkChroot)).withHttpClient(this.httpClientFactory.build())).withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.socketTimeout)).build();
        }
        return ((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.socketTimeout)).withHttpClient(this.httpClientFactory.build())).withBaseSolrUrls(this.solrUrls.toArray(new String[0])).build();
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"solrCollection", (String)this.solrCollection);
        TikaConfig.mustNotBeEmpty((String)"urlFieldName", (String)this.idField);
        TikaConfig.mustNotBeEmpty((String)"parsingIdField", (String)this.parsingIdField);
        TikaConfig.mustNotBeEmpty((String)"failCountField", (String)this.failCountField);
        TikaConfig.mustNotBeEmpty((String)"sizeFieldName", (String)this.sizeFieldName);
        if ((this.solrUrls == null || this.solrUrls.isEmpty()) && (this.solrZkHosts == null || this.solrZkHosts.isEmpty())) {
            throw new IllegalArgumentException("expected either param solrUrls or param solrZkHosts, but neither was specified");
        }
        if (this.solrUrls != null && !this.solrUrls.isEmpty() && this.solrZkHosts != null && !this.solrZkHosts.isEmpty()) {
            throw new IllegalArgumentException("expected either param solrUrls or param solrZkHosts, but both were specified");
        }
    }
}

