/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.sql;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.solr.client.solrj.io.sql.ConnectionImpl;
import org.apache.solr.common.util.SuppressForbidden;

public class DriverImpl
implements Driver {
    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        URI uri = this.processUrl(url);
        this.loadParams(uri, props);
        if (!props.containsKey("collection")) {
            throw new SQLException("The connection url has no connection properties. At a mininum the collection must be specified.");
        }
        String collection = (String)props.remove("collection");
        if (!props.containsKey("aggregationMode")) {
            props.setProperty("aggregationMode", "facet");
        }
        props.setProperty("includeMetadata", "true");
        String zkHost = uri.getAuthority() + uri.getPath();
        return new ConnectionImpl(url, zkHost, collection, props);
    }

    public Connection connect(String url) throws SQLException {
        return this.connect(url, new Properties());
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith("jdbc:solr");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    @SuppressForbidden(reason="Required by jdbc")
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return null;
    }

    protected URI processUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.replaceFirst("jdbc:", ""));
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
        if (uri.getAuthority() == null) {
            throw new SQLException("The zkHost must not be null");
        }
        return uri;
    }

    private void loadParams(URI uri, Properties props) throws SQLException {
        List<NameValuePair> parsedParams = URLEncodedUtils.parse(uri, "UTF-8");
        for (NameValuePair pair : parsedParams) {
            if (pair.getValue() != null) {
                props.put(pair.getName(), pair.getValue());
                continue;
            }
            props.put(pair.getName(), "");
        }
    }

    static {
        try {
            DriverManager.registerDriver(new DriverImpl());
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register driver!", e);
        }
    }
}

